/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.book.editparts;

import com.jaspersoft.studio.book.editors.figures.BookReportFigure;
import com.jaspersoft.studio.book.model.MReportPartContainer;
import com.jaspersoft.studio.model.APropertyNode;
import com.jaspersoft.studio.model.INode;
import com.jaspersoft.studio.model.MReport;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.editpolicies.NonResizableEditPolicy;

public class BookReportEditPart
extends AbstractGraphicalEditPart {
    private BookReportFigure figure = null;
    private PropertyChangeListener updatePart = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent arg0) {
            BookReportEditPart.this.refresh();
        }
    };

    protected void refreshVisuals() {
        super.refreshVisuals();
        ((Figure)this.getFigure()).repaint();
    }

    public void setModel(Object model) {
        MReport bookModel;
        if (this.getModel() != null) {
            bookModel = (MReport)this.getModel();
            bookModel.getPropertyChangeSupport().removePropertyChangeListener(this.updatePart);
        }
        super.setModel(model);
        if (this.getModel() != null) {
            bookModel = (MReport)this.getModel();
            bookModel.getPropertyChangeSupport().addPropertyChangeListener(this.updatePart);
        }
    }

    protected IFigure createFigure() {
        if (this.figure == null) {
            this.figure = new BookReportFigure();
        }
        return this.figure;
    }

    protected void createEditPolicies() {
        NonResizableEditPolicy selectionPolicy = new NonResizableEditPolicy(){

            protected void showSelection() {
            }
        };
        selectionPolicy.setDragAllowed(false);
        this.installEditPolicy("Selection Feedback", (EditPolicy)selectionPolicy);
    }

    protected List<Object> getModelChildren() {
        ArrayList<Object> list = new ArrayList<Object>();
        for (INode node : this.getBookModel().getChildren()) {
            if (!(node instanceof MReportPartContainer)) continue;
            list.add(node);
        }
        return list;
    }

    protected MReport getBookModel() {
        return (MReport)this.getModel();
    }

    public void deactivate() {
        if (this.getModel() != null) {
            APropertyNode bookModel = (APropertyNode)this.getModel();
            bookModel.getPropertyChangeSupport().removePropertyChangeListener(this.updatePart);
        }
        super.deactivate();
    }
}

