/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.book.gallery.controls.render;

import java.util.HashMap;
import org.eclipse.nebula.widgets.gallery.GalleryItem;
import org.eclipse.nebula.widgets.gallery.RendererHelper;
import org.eclipse.nebula.widgets.gallery.RoundedGalleryItemRenderer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.wb.swt.ResourceManager;

public class DraggableGalleryItemRenderer
extends RoundedGalleryItemRenderer {
    protected HashMap<GalleryItem, Rectangle> imagesBounds = new HashMap();

    public void draw(GC gc, GalleryItem item, int index, int x, int y, int width, int height) {
        this._drawImage = item.getImage();
        this._drawForegroundColor = this.getForeground(item);
        gc.setFont(this.getFont(item));
        int useableHeight = height;
        int fontHeight = 0;
        if (item.getText() != null && !"".equals(item.getText()) && this.showLabels) {
            fontHeight = gc.getFontMetrics().getHeight();
            useableHeight -= fontHeight + 2;
        }
        int imageWidth = 0;
        int imageHeight = 0;
        int xShift = 0;
        int yShift = 0;
        Point size = null;
        if (this._drawImage != null) {
            Rectangle itemImageBounds = this._drawImage.getBounds();
            imageWidth = itemImageBounds.width;
            imageHeight = itemImageBounds.height;
            size = RendererHelper.getBestSize((int)imageWidth, (int)imageHeight, (int)(width - 8 - 2 * this.dropShadowsSize), (int)(useableHeight - 8 - 2 * this.dropShadowsSize));
            xShift = RendererHelper.getShift((int)width, (int)size.x);
            yShift = Math.max(useableHeight - size.y, 0);
            if (this.dropShadows) {
                Color c = null;
                int i = this.dropShadowsSize - 1;
                while (i >= 0) {
                    c = (Color)this.dropShadowsColors.get(i);
                    gc.setForeground(c);
                    gc.drawLine(x + width + i - xShift - 1, y + this.dropShadowsSize + yShift, x + width + i - xShift - 1, y + useableHeight + i - yShift);
                    gc.drawLine(x + xShift + this.dropShadowsSize, y + useableHeight + i - yShift - 1, x + width + i - xShift, y - 1 + useableHeight + i - yShift);
                    --i;
                }
            }
        }
        this._drawBackground = this.selected;
        this._drawBackgroundColor = null;
        if (!this._drawBackground && item.getBackground(true) != null) {
            this._drawBackgroundColor = this.getBackground(item);
            if (!RendererHelper.isColorsEquals((Color)this._drawBackgroundColor, (Color)this.galleryBackgroundColor)) {
                this._drawBackground = true;
            }
        }
        if (this._drawBackground) {
            if (this.selected) {
                gc.setBackground(this.selectionBackgroundColor);
                gc.setForeground(this.selectionBackgroundColor);
            } else if (this._drawBackgroundColor != null) {
                gc.setBackground(this._drawBackgroundColor);
            }
            if (this.showRoundedSelectionCorners) {
                gc.fillRoundRectangle(x, y, width, useableHeight, this.selectionRadius, this.selectionRadius);
            } else {
                gc.fillRectangle(x, y, width, height);
            }
            if (item.getText() != null && !"".equals(item.getText()) && this.showLabels) {
                gc.fillRoundRectangle(x, y + height - fontHeight, width, fontHeight, this.selectionRadius, this.selectionRadius);
            }
        }
        if (this.selected) {
            this._drawImage = item.getSelectedImage();
        }
        if (this._drawImage != null && size != null && size.x > 0 && size.y > 0) {
            gc.drawImage(this._drawImage, 0, 0, imageWidth, imageHeight, x + xShift, y + yShift, size.x, size.y);
            this.imagesBounds.put(item, new Rectangle(x + xShift, y + yShift, size.x, size.y));
            this.drawAllOverlays(gc, item, x, y, size, xShift, yShift);
            if (this.selected) {
                gc.setForeground(ResourceManager.getColor((int)26));
                gc.setLineWidth(5);
                gc.drawRoundRectangle(x + xShift, y + yShift, size.x, size.y, 10, 10);
            }
        }
        if (item.getText() != null && !"".equals(item.getText()) && this.showLabels) {
            if (this.selected) {
                gc.setForeground(this.selectionForegroundColor);
                gc.setBackground(this.selectionBackgroundColor);
            } else {
                if (this._drawBackgroundColor != null) {
                    gc.setBackground(this._drawBackgroundColor);
                } else {
                    gc.setBackground(this.backgroundColor);
                }
                if (this._drawForegroundColor != null) {
                    gc.setForeground(this._drawForegroundColor);
                } else {
                    gc.setForeground(this.foregroundColor);
                }
            }
            String text = RendererHelper.createLabel((String)item.getText(), (GC)gc, (int)(width - 10));
            int textWidth = gc.textExtent((String)text).x;
            int textxShift = RendererHelper.getShift((int)width, (int)textWidth);
            gc.drawText(text, x + textxShift, y + height - fontHeight, true);
        }
    }
}

