/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.book.gallery.implementations;

import com.jaspersoft.studio.book.JRBookActivator;
import com.jaspersoft.studio.book.gallery.interfaces.IGalleryElement;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wb.swt.ResourceManager;

public class PageElement
implements IGalleryElement {
    private ImageDescriptor imageDescriptor;
    private String reportPath;

    public PageElement(ImageDescriptor image, String reportPath) {
        this.imageDescriptor = image;
        this.reportPath = reportPath;
    }

    public PageElement(String reportPath) {
        this.reportPath = reportPath;
        this.imageDescriptor = this.getElementImage(reportPath);
    }

    @Override
    public Image getImage() {
        return ResourceManager.getImage((ImageDescriptor)this.imageDescriptor);
    }

    @Override
    public String getTitle() {
        File selectedResource = new File(this.reportPath);
        return selectedResource.getName();
    }

    @Override
    public Object getData() {
        return this.reportPath;
    }

    private ImageDescriptor getElementImage(String jrxmlPath) {
        try {
            String[] imageExtensions = new String[]{".png", ".gif", ".jpg"};
            String baseImageUrl = URLDecoder.decode(jrxmlPath, "utf-8");
            baseImageUrl = baseImageUrl.substring(0, baseImageUrl.length() - ".jrxml".length());
            String[] stringArray = imageExtensions;
            int n = imageExtensions.length;
            int n2 = 0;
            while (n2 < n) {
                String extension = stringArray[n2];
                try {
                    URL iconURL = new File(String.valueOf(baseImageUrl) + extension).toURI().toURL();
                    ImageDescriptor result = this.getIconFromUrl(iconURL);
                    if (result != null) {
                        return result;
                    }
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
                ++n2;
            }
        }
        catch (Exception exception) {}
        return JRBookActivator.getDefault().getImageDescriptor("/icons/blankreport.png");
    }

    private ImageDescriptor getIconFromUrl(URL iconURL) {
        ImageDescriptor descriptor = ImageDescriptor.createFromURL((URL)iconURL);
        if (descriptor != null && descriptor.getImageData() != null) {
            return descriptor;
        }
        return null;
    }
}

