/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.book.model.commands;

import com.jaspersoft.studio.book.wizards.AddGroupWizard;
import com.jaspersoft.studio.editor.expression.ExpressionEditorSupportUtil;
import com.jaspersoft.studio.model.DialogEnabledCommand;
import com.jaspersoft.studio.model.MReport;
import com.jaspersoft.studio.model.group.MGroup;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignGroup;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;

public class CreateGroupForBookCommand
extends Command
implements DialogEnabledCommand {
    private JasperDesign jd;
    private MReport report;
    private JRDesignGroup jrGroup;
    private JRDesignDataset mainDataset;

    public CreateGroupForBookCommand(MReport report) {
        this.report = report;
        this.jd = report.getJasperDesign();
        this.mainDataset = (JRDesignDataset)this.jd.getMainDataset();
    }

    public boolean canExecute() {
        return this.report != null && this.jd != null && this.mainDataset != null;
    }

    public void execute() {
        try {
            this.jd.addGroup(this.jrGroup);
        }
        catch (JRException e) {
            e.printStackTrace();
        }
    }

    public void undo() {
        this.jd.removeGroup((JRGroup)this.jrGroup);
    }

    public boolean canUndo() {
        return this.jd != null && this.jrGroup != null;
    }

    public int openDialog() {
        AddGroupWizard wizard = new AddGroupWizard(this.jd);
        wizard.setExpressionContext(ExpressionEditorSupportUtil.getReportExpressionContext());
        WizardDialog dialog = new WizardDialog(UIUtils.getShell(), (IWizard)wizard);
        dialog.create();
        if (dialog.open() == 0) {
            MGroup srcNode = wizard.getGroup();
            this.jrGroup = srcNode.getValue() == null ? MGroup.createJRGroup((JRDesignDataset)this.mainDataset) : (JRDesignGroup)srcNode.getValue();
            return 0;
        }
        return 1;
    }
}

