/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.dto.adhoc.cache;

import com.jaspersoft.jasperserver.dto.common.DeepCloneable;
import com.jaspersoft.jasperserver.dto.utils.ValueObjectUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
public class CacheEntryDetails
implements DeepCloneable<CacheEntryDetails> {
    private static final String NO_QUERY = "(empty)";
    private static final String PARAM_PARAMS = "params";
    private static final String PARAM_MEM_USED = "memUsed";
    private static final String PARAM_SORT = "sort";
    private String id;
    private long createdTime;
    private long fetchTime;
    private long queryTime;
    private long lastUsedTime;
    private long age;
    private long idle;
    private long timesUsed;
    private String query;
    private String datasourceUri;
    private String connectionUrl;
    private long rows;
    private long memUsed;
    private State status;
    private Map<String, String> params;
    private Set<String> usedBy;

    public CacheEntryDetails() {
    }

    public CacheEntryDetails(CacheEntryDetails source) {
        ValueObjectUtils.checkNotNull(source);
        this.id = source.getId();
        this.createdTime = source.getCreatedTime();
        this.fetchTime = source.getFetchTime();
        this.queryTime = source.getQueryTime();
        this.lastUsedTime = source.getLastUsedTime();
        this.age = source.getAge();
        this.idle = source.getIdle();
        this.timesUsed = source.getTimesUsed();
        this.query = source.getQuery();
        this.datasourceUri = source.getDatasourceUri();
        this.connectionUrl = source.getConnectionUrl();
        this.rows = source.getRows();
        this.memUsed = source.getMemUsed();
        this.status = source.getStatus();
        this.params = source.getParams() != null ? new HashMap<String, String>(source.getParams()) : null;
        this.usedBy = source.getUsedBy() != null ? new HashSet<String>(source.getUsedBy()) : null;
    }

    public String getId() {
        return this.id;
    }

    public CacheEntryDetails setId(String id) {
        this.id = id;
        return this;
    }

    public long getCreatedTime() {
        return this.createdTime;
    }

    public CacheEntryDetails setCreatedTime(long createdTime) {
        this.createdTime = createdTime;
        return this;
    }

    public long getFetchTime() {
        return this.fetchTime;
    }

    public CacheEntryDetails setFetchTime(long fetchTime) {
        this.fetchTime = fetchTime;
        return this;
    }

    public long getQueryTime() {
        return this.queryTime;
    }

    public CacheEntryDetails setQueryTime(long queryTime) {
        this.queryTime = queryTime;
        return this;
    }

    public long getLastUsedTime() {
        return this.lastUsedTime;
    }

    public CacheEntryDetails setLastUsedTime(long lastUsedTime) {
        this.lastUsedTime = lastUsedTime;
        return this;
    }

    public long getAge() {
        return this.age;
    }

    public CacheEntryDetails setAge(long age) {
        this.age = age;
        return this;
    }

    public long getIdle() {
        return this.idle;
    }

    public CacheEntryDetails setIdle(long idle) {
        this.idle = idle;
        return this;
    }

    public long getTimesUsed() {
        return this.timesUsed;
    }

    public CacheEntryDetails setTimesUsed(long timesUsed) {
        this.timesUsed = timesUsed;
        return this;
    }

    public String getQuery() {
        return this.query;
    }

    public CacheEntryDetails setQuery(String query) {
        this.query = query;
        return this;
    }

    public String getDatasourceUri() {
        return this.datasourceUri;
    }

    public CacheEntryDetails setDatasourceUri(String datasourceUri) {
        this.datasourceUri = datasourceUri;
        return this;
    }

    public String getConnectionUrl() {
        return this.connectionUrl;
    }

    public CacheEntryDetails setConnectionUrl(String connectionUrl) {
        this.connectionUrl = connectionUrl;
        return this;
    }

    public long getRows() {
        return this.rows;
    }

    public CacheEntryDetails setRows(long rows) {
        this.rows = rows;
        return this;
    }

    public long getMemUsed() {
        return this.memUsed;
    }

    public CacheEntryDetails setMemUsed(long memUsed) {
        this.memUsed = memUsed;
        return this;
    }

    public State getStatus() {
        return this.status;
    }

    public CacheEntryDetails setStatus(State status) {
        this.status = status;
        return this;
    }

    public Map<String, String> getParams() {
        return this.params;
    }

    public CacheEntryDetails setParams(Map<String, String> params) {
        this.params = params;
        return this;
    }

    public Set<String> getUsedBy() {
        return this.usedBy;
    }

    public CacheEntryDetails setUsedBy(Set<String> usedBy) {
        this.usedBy = usedBy;
        return this;
    }

    @Override
    public CacheEntryDetails deepClone() {
        return new CacheEntryDetails(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CacheEntryDetails)) {
            return false;
        }
        CacheEntryDetails that = (CacheEntryDetails)o;
        return this.createdTime == that.createdTime && this.fetchTime == that.fetchTime && this.queryTime == that.queryTime && this.lastUsedTime == that.lastUsedTime && this.age == that.age && this.idle == that.idle && this.timesUsed == that.timesUsed && this.rows == that.rows && Double.compare(that.memUsed, this.memUsed) == 0 && Objects.equals(this.id, that.id) && Objects.equals(this.query, that.query) && Objects.equals(this.datasourceUri, that.datasourceUri) && Objects.equals(this.connectionUrl, that.connectionUrl) && this.status == that.status && Objects.equals(this.params, that.params) && Objects.equals(this.usedBy, that.usedBy);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.createdTime, this.fetchTime, this.queryTime, this.lastUsedTime, this.age, this.idle, this.timesUsed, this.query, this.datasourceUri, this.connectionUrl, this.rows, this.memUsed, this.status, this.params, this.usedBy});
    }

    public String toString() {
        return new StringJoiner(", ", CacheEntryDetails.class.getSimpleName() + "{", "}").add("id='" + this.id + "'").add("createdTime=" + this.createdTime).add("fetchTime=" + this.fetchTime).add("queryTime=" + this.queryTime).add("lastUsedTime=" + this.lastUsedTime).add("age=" + this.age).add("idle=" + this.idle).add("timesUsed=" + this.timesUsed).add("query='" + this.query + "'").add("datasourceUri='" + this.datasourceUri + "'").add("connectionUrl='" + this.connectionUrl + "'").add("rows=" + this.rows).add("memUsed=" + this.memUsed).add("status=" + (Object)((Object)this.status)).add("params=" + this.params).add("usedBy=" + this.usedBy).toString();
    }

    public static enum State {
        New,
        WaitingForResults,
        FetchingResults,
        Complete,
        Canceled,
        Error,
        Expired;

    }
}

