/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.dto.adhoc.component;

import com.jaspersoft.jasperserver.dto.adhoc.component.ClientComponent;
import com.jaspersoft.jasperserver.dto.utils.ValueObjectUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;

public class ClientGenericComponent
implements ClientComponent,
Serializable {
    private Map<String, Object> propertyMap;
    private String componentType;
    private List<? extends ClientComponent> components;

    public ClientGenericComponent() {
        this.propertyMap = new LinkedHashMap<String, Object>();
        this.components = new ArrayList<ClientComponent>();
    }

    public ClientGenericComponent(ClientGenericComponent component) {
        ValueObjectUtils.checkNotNull(component);
        this.propertyMap = ValueObjectUtils.copyOf(component.getProperties());
        this.componentType = component.getComponentType();
        this.components = ValueObjectUtils.copyOf(component.getComponents());
    }

    public ClientGenericComponent deepClone() {
        return new ClientGenericComponent(this);
    }

    @Override
    public Map<String, Object> getProperties() {
        return this.propertyMap;
    }

    public ClientGenericComponent setProperties(Map<String, Object> properties) {
        this.propertyMap = new LinkedHashMap<String, Object>();
        if (properties != null) {
            this.propertyMap.putAll(properties);
        }
        return this;
    }

    @Override
    public Object getProperty(String key) {
        return this.propertyMap.get(key);
    }

    protected ClientGenericComponent setProperty(String key, Object value) {
        this.propertyMap.put(key, value);
        return this;
    }

    @Override
    public String getComponentType() {
        return this.componentType;
    }

    public ClientGenericComponent setComponentType(String type) {
        this.componentType = type;
        return this;
    }

    @Override
    @XmlElementWrapper(name="components")
    @XmlElement(type=ClientGenericComponent.class, name="components")
    public List<ClientComponent> getComponents() {
        return this.components;
    }

    public ClientGenericComponent setComponents(List<ClientGenericComponent> components) {
        this.components = components != null ? components : new ArrayList();
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ClientGenericComponent)) {
            return false;
        }
        ClientGenericComponent that = (ClientGenericComponent)o;
        return Objects.equals(this.propertyMap, that.propertyMap) && Objects.equals(this.componentType, that.componentType) && Objects.equals(this.components, that.components);
    }

    public int hashCode() {
        return Objects.hash(this.propertyMap, this.componentType, this.components);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ClientGenericComponent{");
        sb.append("propertyMap=").append(this.propertyMap);
        sb.append(", componentType='").append(this.componentType).append('\'');
        sb.append(", components=").append(this.components);
        sb.append('}');
        return sb.toString();
    }
}

