/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.dto.adhoc.dataset;

import com.jaspersoft.jasperserver.dto.adhoc.dataset.ClientAxisNode;
import com.jaspersoft.jasperserver.dto.adhoc.dataset.ClientMultiAxisAggregationLevel;
import com.jaspersoft.jasperserver.dto.adhoc.dataset.ClientMultiAxisDatasetLevel;
import com.jaspersoft.jasperserver.dto.adhoc.dataset.ClientMultiAxisGroupLevel;
import com.jaspersoft.jasperserver.dto.common.DeepCloneable;
import com.jaspersoft.jasperserver.dto.utils.ValueObjectUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlElements;

public class ClientAxis
implements DeepCloneable<ClientAxis>,
Serializable {
    private ClientAxisNode axisNode;
    private List<ClientMultiAxisDatasetLevel> levels = new ArrayList<ClientMultiAxisDatasetLevel>();

    public ClientAxis() {
    }

    public ClientAxis(ClientAxis axis) {
        ValueObjectUtils.checkNotNull(axis);
        this.axisNode = ValueObjectUtils.copyOf(axis.getAxisNode());
        this.levels = ValueObjectUtils.copyOf(axis.getLevels());
    }

    public ClientAxisNode getAxisNode() {
        return this.axisNode;
    }

    public ClientAxis setAxisNode(ClientAxisNode axisNode) {
        this.axisNode = axisNode;
        return this;
    }

    @XmlElementWrapper(name="levels")
    @XmlElements(value={@XmlElement(name="level", type=ClientMultiAxisGroupLevel.class), @XmlElement(name="aggregation", type=ClientMultiAxisAggregationLevel.class)})
    public List<ClientMultiAxisDatasetLevel> getLevels() {
        return this.levels;
    }

    public ClientAxis setLevels(List<ClientMultiAxisDatasetLevel> levels) {
        this.levels = levels == null ? new ArrayList<ClientMultiAxisDatasetLevel>() : levels;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClientAxis that = (ClientAxis)o;
        if (this.axisNode != null ? !this.axisNode.equals(that.axisNode) : that.axisNode != null) {
            return false;
        }
        return this.levels.equals(that.levels);
    }

    public int hashCode() {
        int result = this.axisNode != null ? this.axisNode.hashCode() : 0;
        result = 31 * result + this.levels.hashCode();
        return result;
    }

    public String toString() {
        return "ClientAxis{axisNode=" + this.axisNode + ", levels=" + this.levels + '}';
    }

    @Override
    public ClientAxis deepClone() {
        return new ClientAxis(this);
    }
}

