/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.dto.adhoc.dataset;

import com.jaspersoft.jasperserver.dto.common.DeepCloneable;
import com.jaspersoft.jasperserver.dto.utils.ValueObjectUtils;
import java.io.Serializable;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="axisNode")
public class ClientAxisNode
implements Serializable,
DeepCloneable<ClientAxisNode> {
    private Integer memberIdx;
    private Integer dataIdx;
    private List<ClientAxisNode> children;
    private boolean isAll = false;

    public ClientAxisNode() {
    }

    public ClientAxisNode(ClientAxisNode node) {
        ValueObjectUtils.checkNotNull(node);
        this.memberIdx = node.getMemberIdx();
        this.dataIdx = node.getDataIdx();
        this.children = ValueObjectUtils.copyOf(node.getChildren());
        this.isAll = node.isAll();
    }

    public ClientAxisNode setChildren(List<ClientAxisNode> children) {
        this.children = children;
        return this;
    }

    public Integer getDataIdx() {
        return this.dataIdx;
    }

    public ClientAxisNode setDataIdx(Integer dataIdx) {
        this.dataIdx = dataIdx;
        return this;
    }

    @XmlElement(name="memberIdx")
    public Integer getMemberIdx() {
        return this.memberIdx;
    }

    public ClientAxisNode setMemberIdx(Integer memberIdx) {
        this.memberIdx = memberIdx;
        return this;
    }

    @XmlElementWrapper(name="children")
    @XmlElement(nillable=false, required=false, name="axisNode")
    public List<ClientAxisNode> getChildren() {
        return this.children;
    }

    @XmlElement(name="all")
    public boolean isAll() {
        return this.isAll;
    }

    public ClientAxisNode setAll(boolean isAll) {
        this.isAll = isAll;
        return this;
    }

    public String toString() {
        return "ClientAxisNode{memberIdx=" + this.memberIdx + ", dataIdx=" + this.dataIdx + ", isAll=" + this.isAll + ", children=" + this.children + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClientAxisNode axisNode = (ClientAxisNode)o;
        if (this.isAll != axisNode.isAll) {
            return false;
        }
        if (this.memberIdx != null ? !this.memberIdx.equals(axisNode.memberIdx) : axisNode.memberIdx != null) {
            return false;
        }
        if (this.dataIdx != null ? !this.dataIdx.equals(axisNode.dataIdx) : axisNode.dataIdx != null) {
            return false;
        }
        return !(this.children == null ? axisNode.children != null : !this.children.equals(axisNode.children));
    }

    public int hashCode() {
        int result = this.memberIdx != null ? this.memberIdx.hashCode() : 0;
        result = 31 * result + (this.dataIdx != null ? this.dataIdx.hashCode() : 0);
        result = 31 * result + (this.children != null ? this.children.hashCode() : 0);
        result = 31 * result + (this.isAll ? 1 : 0);
        return result;
    }

    @Override
    public ClientAxisNode deepClone() {
        return new ClientAxisNode(this);
    }
}

