/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.dto.adhoc.dataset;

import com.jaspersoft.jasperserver.dto.adhoc.dataset.AbstractClientDatasetLevel;
import com.jaspersoft.jasperserver.dto.adhoc.dataset.ClientDatasetFieldReference;
import com.jaspersoft.jasperserver.dto.utils.ValueObjectUtils;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;

public class ClientDatasetGroupLevel
extends AbstractClientDatasetLevel {
    private String fieldRef;
    private String type;
    private List<String> members;

    public ClientDatasetGroupLevel() {
    }

    public ClientDatasetGroupLevel(ClientDatasetGroupLevel level) {
        super(level);
        this.fieldRef = level.getFieldRef();
        this.type = level.getType();
        this.members = ValueObjectUtils.copyOf(level.getMembers());
    }

    @XmlElement(name="reference")
    public String getFieldRef() {
        return this.fieldRef;
    }

    public ClientDatasetGroupLevel setFieldRef(String name) {
        this.fieldRef = name;
        return this;
    }

    @XmlElementWrapper(name="members")
    @XmlElement(name="member")
    public List<String> getMembers() {
        return this.members;
    }

    public ClientDatasetGroupLevel setMembers(List<String> members) {
        this.members = members;
        return this;
    }

    @Override
    @XmlElementWrapper(name="aggregations")
    @XmlElement(name="aggregation")
    public List<ClientDatasetFieldReference> getFieldRefs() {
        return super.getFieldRefs();
    }

    @XmlElement(name="type")
    public String getType() {
        return this.type;
    }

    public ClientDatasetGroupLevel setType(String type) {
        this.type = type;
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ClientDatasetGroupLevel that = (ClientDatasetGroupLevel)o;
        if (this.fieldRef != null ? !this.fieldRef.equals(that.fieldRef) : that.fieldRef != null) {
            return false;
        }
        if (this.type != null ? !this.type.equals(that.type) : that.type != null) {
            return false;
        }
        return !(this.members == null ? that.members != null : !this.members.equals(that.members));
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.fieldRef != null ? this.fieldRef.hashCode() : 0);
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        result = 31 * result + (this.members != null ? this.members.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "ClientDatasetGroupLevel{fieldRef='" + this.fieldRef + '\'' + ", type='" + this.type + '\'' + ", members=" + this.members + '}';
    }

    public ClientDatasetGroupLevel deepClone() {
        return new ClientDatasetGroupLevel(this);
    }
}

