/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.dto.adhoc.dataset;

import com.jaspersoft.jasperserver.dto.adhoc.dataset.ClientFlatDatasetFieldReference;
import com.jaspersoft.jasperserver.dto.common.DeepCloneable;
import com.jaspersoft.jasperserver.dto.utils.ValueObjectUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="flatDataset")
public class ClientFlatDataset
implements DeepCloneable<ClientFlatDataset>,
Serializable {
    private int counts;
    private List<ClientFlatDatasetFieldReference> fields = new ArrayList<ClientFlatDatasetFieldReference>();
    private List<String[]> rows;

    public ClientFlatDataset() {
    }

    public ClientFlatDataset(ClientFlatDataset dataset) {
        ValueObjectUtils.checkNotNull(dataset);
        this.counts = dataset.getCounts();
        this.fields = ValueObjectUtils.copyOf(dataset.getFields());
        this.rows = ValueObjectUtils.copyOf(dataset.getRows());
    }

    @XmlElement(name="counts")
    public int getCounts() {
        return this.counts;
    }

    public ClientFlatDataset setCounts(int counts) {
        this.counts = counts;
        return this;
    }

    public List<ClientFlatDatasetFieldReference> getFields() {
        return this.fields;
    }

    public ClientFlatDataset setFields(List<ClientFlatDatasetFieldReference> fields) {
        this.fields = fields == null ? new ArrayList<ClientFlatDatasetFieldReference>() : fields;
        return this;
    }

    @XmlElementWrapper(name="rows")
    @XmlElement(name="row")
    public List<String[]> getRows() {
        return this.rows;
    }

    public ClientFlatDataset setRows(List<String[]> rows) {
        this.rows = rows;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClientFlatDataset that = (ClientFlatDataset)o;
        if (this.counts != that.counts) {
            return false;
        }
        if (!this.fields.equals(that.fields)) {
            return false;
        }
        return ValueObjectUtils.isListsOfArraysEquals(this.rows, that.rows);
    }

    public int hashCode() {
        int result = this.counts;
        result = 31 * result + this.fields.hashCode();
        result = 31 * result + ValueObjectUtils.hashCodeOfListOfArrays(this.rows);
        return result;
    }

    public String toString() {
        return "ClientFlatDataset{counts=" + this.counts + ", fields=" + this.fields + ", rows=" + this.rows + '}';
    }

    @Override
    public ClientFlatDataset deepClone() {
        return new ClientFlatDataset(this);
    }
}

