/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.dto.adhoc.dataset;

import com.jaspersoft.jasperserver.dto.adhoc.dataset.ClientAxis;
import com.jaspersoft.jasperserver.dto.common.DeepCloneable;
import com.jaspersoft.jasperserver.dto.utils.ValueObjectUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
public class ClientMultiAxisDataset
implements DeepCloneable<ClientMultiAxisDataset>,
Serializable {
    private List<ClientAxis> axes;
    private List<String[]> data;
    private List<Integer> counts = new ArrayList<Integer>();

    public ClientMultiAxisDataset() {
    }

    public ClientMultiAxisDataset(ClientMultiAxisDataset dataset) {
        ValueObjectUtils.checkNotNull(dataset);
        this.axes = ValueObjectUtils.copyOf(dataset.getAxes());
        this.data = ValueObjectUtils.copyOf(dataset.getData());
        this.counts = ValueObjectUtils.copyOf(dataset.getCounts());
    }

    @XmlElementWrapper(name="axes")
    @XmlElement(name="axis")
    public List<ClientAxis> getAxes() {
        return this.axes;
    }

    public ClientMultiAxisDataset setAxes(List<ClientAxis> axes) {
        this.axes = axes;
        return this;
    }

    @XmlElementWrapper(name="data")
    @XmlElement(name="column")
    public List<String[]> getData() {
        return this.data;
    }

    public ClientMultiAxisDataset setData(List<String[]> data) {
        this.data = data;
        return this;
    }

    public List<Integer> getCounts() {
        return this.counts;
    }

    public ClientMultiAxisDataset setCounts(List<Integer> counts) {
        this.counts = counts == null ? new ArrayList<Integer>() : counts;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClientMultiAxisDataset that = (ClientMultiAxisDataset)o;
        if (this.axes != null ? !this.axes.equals(that.axes) : that.axes != null) {
            return false;
        }
        if (!this.equalsListOfArrays(this.data, that.data)) {
            return false;
        }
        return this.counts.equals(that.counts);
    }

    private <T> boolean equalsListOfArrays(List<T[]> first, List<T[]> second) {
        if (first == null && second == null) {
            return true;
        }
        if (first == null) {
            return false;
        }
        if (second == null) {
            return false;
        }
        if (first.size() != second.size()) {
            return false;
        }
        for (int i = 0; i < first.size(); ++i) {
            Object[] secondItem;
            Object[] firstItem = first.get(i);
            if (Arrays.equals(firstItem, secondItem = second.get(i))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result;
        int n = result = this.axes != null ? this.axes.hashCode() : 0;
        if (this.data != null) {
            for (Object[] objectArray : this.data) {
                result = 31 * result + Arrays.hashCode(objectArray);
            }
        }
        result = 31 * result + this.counts.hashCode();
        return result;
    }

    public String toString() {
        return "ClientMultiAxisDataset{axes=" + this.axes + ", data=" + this.data + ", counts=" + this.counts + '}';
    }

    @Override
    public ClientMultiAxisDataset deepClone() {
        return new ClientMultiAxisDataset(this);
    }
}

