/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.dto.adhoc.dataset;

import com.jaspersoft.jasperserver.dto.adhoc.dataset.AbstractClientDatasetLevel;
import com.jaspersoft.jasperserver.dto.adhoc.dataset.AbstractClientDatasetLevelNode;
import com.jaspersoft.jasperserver.dto.adhoc.dataset.ClientDatasetAllLevel;
import com.jaspersoft.jasperserver.dto.adhoc.dataset.ClientDatasetAllLevelNode;
import com.jaspersoft.jasperserver.dto.adhoc.dataset.ClientDatasetDetailLevel;
import com.jaspersoft.jasperserver.dto.adhoc.dataset.ClientDatasetDetailLevelNode;
import com.jaspersoft.jasperserver.dto.adhoc.dataset.ClientDatasetGroupLevel;
import com.jaspersoft.jasperserver.dto.adhoc.dataset.ClientDatasetGroupLevelNode;
import com.jaspersoft.jasperserver.dto.common.DeepCloneable;
import com.jaspersoft.jasperserver.dto.utils.ValueObjectUtils;
import java.io.Serializable;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="multiLevelDataset")
public class ClientMultiLevelDataset
implements DeepCloneable<ClientMultiLevelDataset>,
Serializable {
    private Integer counts;
    private List<AbstractClientDatasetLevel> levels;
    private List<AbstractClientDatasetLevelNode> levelDataNodes;

    public ClientMultiLevelDataset() {
    }

    public ClientMultiLevelDataset(ClientMultiLevelDataset other) {
        ValueObjectUtils.checkNotNull(other);
        this.counts = other.getCounts();
        this.levels = ValueObjectUtils.copyOf(other.getLevels());
        this.levelDataNodes = ValueObjectUtils.copyOf(other.getLevelDataNodes());
    }

    @XmlElement(name="counts")
    public Integer getCounts() {
        return this.counts;
    }

    public ClientMultiLevelDataset setCounts(Integer counts) {
        this.counts = counts;
        return this;
    }

    @XmlElementWrapper(name="levels")
    @XmlElements(value={@XmlElement(name="all", type=ClientDatasetAllLevel.class), @XmlElement(name="group", type=ClientDatasetGroupLevel.class), @XmlElement(name="detail", type=ClientDatasetDetailLevel.class)})
    public List<AbstractClientDatasetLevel> getLevels() {
        return this.levels;
    }

    public ClientMultiLevelDataset setLevels(List<AbstractClientDatasetLevel> levels) {
        this.levels = levels;
        return this;
    }

    @XmlElementWrapper(name="levelDataNodes")
    @XmlElements(value={@XmlElement(name="all", type=ClientDatasetAllLevelNode.class), @XmlElement(name="group", type=ClientDatasetGroupLevelNode.class), @XmlElement(name="detail", type=ClientDatasetDetailLevelNode.class)})
    public List<AbstractClientDatasetLevelNode> getLevelDataNodes() {
        return this.levelDataNodes;
    }

    public ClientMultiLevelDataset setLevelDataNodes(List<AbstractClientDatasetLevelNode> levelDataNodes) {
        this.levelDataNodes = levelDataNodes;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClientMultiLevelDataset that = (ClientMultiLevelDataset)o;
        if (this.counts != null ? !this.counts.equals(that.counts) : that.counts != null) {
            return false;
        }
        if (this.levelDataNodes != null ? !this.levelDataNodes.equals(that.levelDataNodes) : that.levelDataNodes != null) {
            return false;
        }
        return !(this.levels != null ? !this.levels.equals(that.levels) : that.levels != null);
    }

    public int hashCode() {
        int result = this.counts != null ? this.counts.hashCode() : 0;
        result = 31 * result + (this.levels != null ? this.levels.hashCode() : 0);
        result = 31 * result + (this.levelDataNodes != null ? this.levelDataNodes.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "ClientMultiLevelDataset{counts=" + this.counts + ", levels=" + this.levels + ", levelDataNodes=" + this.levelDataNodes + '}';
    }

    @Override
    public ClientMultiLevelDataset deepClone() {
        return new ClientMultiLevelDataset(this);
    }
}

