/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.dto.adhoc.query;

import com.jaspersoft.jasperserver.dto.adhoc.datasource.ClientDataSourceField;
import com.jaspersoft.jasperserver.dto.adhoc.query.el.ClientExpression;
import com.jaspersoft.jasperserver.dto.adhoc.query.el.ClientExpressionContainer;
import com.jaspersoft.jasperserver.dto.adhoc.query.field.ClientQueryAggregatedField;
import com.jaspersoft.jasperserver.dto.adhoc.query.field.ClientQueryField;

public enum ClientAggregates {
    COUNT_ALL("CountAll"),
    COUNT_DISTINCT("CountDistinct"),
    MODE("Mode"),
    SUM("Sum"),
    AGGREGATE_FORMULA("AggregateFormula"),
    AVERAGE("Average");

    private String funName;

    private ClientAggregates(String funName) {
        this.funName = funName;
    }

    public String getFunName() {
        return this.funName;
    }

    public static ClientQueryAggregatedField countAll(ClientQueryField field) {
        return ClientAggregates.aggregate(field, COUNT_ALL.getFunName(), null);
    }

    public static ClientQueryAggregatedField countAll(ClientDataSourceField field) {
        return ClientAggregates.aggregate(field, COUNT_ALL.getFunName(), null);
    }

    public static ClientQueryAggregatedField sum(String id, ClientQueryField field) {
        return ClientAggregates.aggregate(id, field, SUM.getFunName(), null);
    }

    public static ClientQueryAggregatedField sum(ClientQueryField field) {
        return ClientAggregates.aggregate(field, SUM.getFunName(), null);
    }

    public static ClientQueryAggregatedField sum(ClientDataSourceField field) {
        return ClientAggregates.aggregate(field, SUM.getFunName(), null);
    }

    public static ClientQueryAggregatedField aggregateFormula(ClientDataSourceField field) {
        return ClientAggregates.aggregate(field, AGGREGATE_FORMULA.getFunName(), null);
    }

    public static ClientQueryAggregatedField aggregateFormula(String field) {
        return ClientAggregates.aggregate(field).setAggregateFunction(AGGREGATE_FORMULA.getFunName());
    }

    public static ClientQueryAggregatedField countDistinct(ClientQueryField field) {
        return ClientAggregates.aggregate(field, COUNT_DISTINCT.getFunName(), null);
    }

    public static ClientQueryAggregatedField aggregate(ClientQueryField field, String name, String arg) {
        return ClientAggregates.aggregate(null, field, name, null, arg);
    }

    public static ClientQueryAggregatedField aggregate(String id, ClientQueryField field, String name, String arg) {
        return ClientAggregates.aggregate(id, field, name, null, arg);
    }

    public static ClientQueryAggregatedField aggregate(String id, ClientQueryField field, String funcName, String expr, String args) {
        String fieldRef = field.getId();
        if (fieldRef == null) {
            fieldRef = field.getFieldName();
        }
        return new ClientQueryAggregatedField().setId(id).setFieldReference(fieldRef).setAggregateFunction(funcName).setExpressionContainer(expr != null ? new ClientExpressionContainer(expr) : null).setAggregateArg(args);
    }

    public static ClientQueryAggregatedField aggregate(ClientDataSourceField field, String name, String arg) {
        return ClientAggregates.aggregate(field, name, null, arg);
    }

    public static ClientQueryAggregatedField aggregate(ClientDataSourceField field, String funcName, String expr, String args) {
        return ClientAggregates.aggregate(null, field, funcName, expr, args);
    }

    public static ClientQueryAggregatedField aggregate(String id, ClientDataSourceField field, String funcName, String expr, String args) {
        return new ClientQueryAggregatedField().setDataSourceField(field).setAggregateFunction(funcName).setExpressionContainer(expr != null ? new ClientExpressionContainer(expr) : null).setAggregateArg(args);
    }

    public static ClientQueryAggregatedField aggregate(ClientDataSourceField field) {
        return new ClientQueryAggregatedField().setDataSourceField(field);
    }

    public static ClientQueryAggregatedField aggregate(ClientQueryField field) {
        return new ClientQueryAggregatedField().setFieldReference(field.getId() == null ? field.getFieldName() : field.getId());
    }

    public static ClientQueryAggregatedField custom(ClientQueryField field, String expr) {
        return ClientAggregates.aggregate(field).setExpressionContainer(expr != null ? new ClientExpressionContainer(expr) : null);
    }

    public static ClientQueryAggregatedField custom(ClientDataSourceField field, String expr) {
        return ClientAggregates.aggregate(field).setExpressionContainer(expr != null ? new ClientExpressionContainer(expr) : null);
    }

    public static ClientQueryAggregatedField custom(ClientQueryField field, ClientExpression expr) {
        return ClientAggregates.aggregate(field).setExpressionContainer(expr != null ? new ClientExpressionContainer(expr) : null);
    }

    public static ClientQueryAggregatedField custom(ClientDataSourceField field, ClientExpression expr) {
        return ClientAggregates.aggregate(field).setExpressionContainer(expr != null ? new ClientExpressionContainer(expr) : null);
    }

    public static ClientQueryAggregatedField custom(String id, ClientExpression expr) {
        return new ClientQueryAggregatedField().setId(id).setExpressionContainer(expr != null ? new ClientExpressionContainer(expr) : null);
    }

    public static ClientQueryAggregatedField aggregate(String field) {
        return new ClientQueryAggregatedField().setFieldReference(field);
    }
}

