/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.dto.adhoc.query;

import com.jaspersoft.jasperserver.dto.adhoc.query.ClientField;
import com.jaspersoft.jasperserver.dto.adhoc.query.ClientQuery;
import com.jaspersoft.jasperserver.dto.adhoc.query.field.ClientQueryGroup;
import com.jaspersoft.jasperserver.dto.adhoc.query.group.ClientQueryGroupBy;
import com.jaspersoft.jasperserver.dto.adhoc.query.order.ClientGenericOrder;
import com.jaspersoft.jasperserver.dto.adhoc.query.select.ClientSelect;
import com.jaspersoft.jasperserver.dto.utils.ValueObjectUtils;
import java.util.List;
import java.util.stream.Collectors;
import javax.validation.Valid;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;

@XmlRootElement(name="multiLevelQuery")
public class ClientMultiLevelQuery
extends ClientQuery {
    @Valid
    private ClientQueryGroupBy groupBy;
    @Valid
    private List<ClientGenericOrder> orderBy;

    public ClientMultiLevelQuery() {
    }

    public ClientMultiLevelQuery(ClientMultiLevelQuery query) {
        super(query);
        this.groupBy = ValueObjectUtils.copyOf(query.getGroupBy());
        this.orderBy = ValueObjectUtils.copyOf(query.getOrderBy());
    }

    @Override
    public ClientMultiLevelQuery setSelect(ClientSelect select) {
        super.setSelect(select);
        return this;
    }

    @XmlTransient
    public ClientQueryGroupBy getGroupBy() {
        return this.groupBy;
    }

    public ClientMultiLevelQuery setGroupBy(ClientQueryGroupBy groupBy) {
        this.groupBy = groupBy;
        return this;
    }

    @XmlElementWrapper(name="groupBy")
    @XmlElements(value={@XmlElement(name="group", type=ClientQueryGroup.class), @XmlElement(name="allGroup", type=ClientQueryGroup.ClientAllGroup.class)})
    public List<? extends ClientQueryGroup> getGroups() {
        return this.groupBy != null ? this.groupBy.getGroups() : null;
    }

    public ClientMultiLevelQuery setGroups(List<? extends ClientQueryGroup> groups) {
        ClientQueryGroupBy clientQueryGroupBy = new ClientQueryGroupBy().setGroups(groups);
        this.setGroupBy(clientQueryGroupBy);
        return this;
    }

    @XmlElementWrapper(name="orderBy")
    @XmlElement(name="field")
    public List<ClientGenericOrder> getOrderBy() {
        return this.orderBy;
    }

    public ClientMultiLevelQuery setOrderBy(List<ClientGenericOrder> orderBy) {
        this.orderBy = orderBy;
        return this;
    }

    public ClientMultiLevelQuery setOrderByStr(List<String> orderBy) {
        this.orderBy = orderBy.stream().map(s -> new ClientGenericOrder((String)s)).collect(Collectors.toList());
        return this;
    }

    @Override
    @XmlTransient
    public List<ClientField> getSelectedFields() {
        return super.getSelectedFields();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ClientMultiLevelQuery that = (ClientMultiLevelQuery)o;
        if (this.groupBy != null ? !this.groupBy.equals(that.groupBy) : that.groupBy != null) {
            return false;
        }
        return this.orderBy != null ? this.orderBy.equals(that.orderBy) : that.orderBy == null;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.groupBy != null ? this.groupBy.hashCode() : 0);
        result = 31 * result + (this.orderBy != null ? this.orderBy.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return "ClientMultiLevelQuery{groupBy=" + this.groupBy + ", orderBy=" + this.orderBy + "} " + super.toString();
    }

    public ClientMultiLevelQuery deepClone() {
        return new ClientMultiLevelQuery(this);
    }
}

