/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.dto.adhoc.query;

import com.jaspersoft.jasperserver.dto.adhoc.query.ClientField;
import com.jaspersoft.jasperserver.dto.adhoc.query.ClientIdentifiable;
import com.jaspersoft.jasperserver.dto.adhoc.query.ClientWhere;
import com.jaspersoft.jasperserver.dto.adhoc.query.ast.ClientQueryVisitor;
import com.jaspersoft.jasperserver.dto.adhoc.query.from.ClientFrom;
import com.jaspersoft.jasperserver.dto.adhoc.query.group.ClientGroupBy;
import com.jaspersoft.jasperserver.dto.adhoc.query.group.axis.ClientAxis;
import com.jaspersoft.jasperserver.dto.adhoc.query.order.ClientOrder;
import com.jaspersoft.jasperserver.dto.adhoc.query.select.ClientSelect;
import com.jaspersoft.jasperserver.dto.common.DeepCloneable;
import com.jaspersoft.jasperserver.dto.utils.ValueObjectUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;

public abstract class ClientQuery
implements DeepCloneable,
Serializable {
    @Valid
    private ClientSelect select;
    @Valid
    private ClientFrom from;
    @Valid
    private ClientWhere where;
    private Integer limit;

    public ClientQuery() {
    }

    public ClientQuery(ClientQuery query) {
        ValueObjectUtils.checkNotNull(query);
        this.select = ValueObjectUtils.copyOf(query.getSelect());
        this.from = ValueObjectUtils.copyOf(query.getFrom());
        this.where = ValueObjectUtils.copyOf(query.getWhere());
        this.limit = query.getLimit();
    }

    public ClientWhere getWhere() {
        return this.where;
    }

    public ClientQuery setWhere(ClientWhere where) {
        this.where = where;
        return this;
    }

    public ClientSelect getSelect() {
        return this.select;
    }

    public ClientQuery setSelect(ClientSelect select) {
        this.select = select;
        return this;
    }

    public ClientFrom getFrom() {
        return this.from;
    }

    public ClientQuery setFrom(ClientFrom from) {
        this.from = from;
        return this;
    }

    public abstract <T extends ClientGroupBy> T getGroupBy();

    public abstract List<? extends ClientOrder> getOrderBy();

    public Integer getLimit() {
        return this.limit;
    }

    public ClientQuery setLimit(Integer limit) {
        this.limit = limit;
        return this;
    }

    public List<ClientField> getSelectedFields() {
        ArrayList<ClientField> fields = new ArrayList<ClientField>();
        if (this.select != null) {
            if (this.select.getFields() != null) {
                for (Object object : this.select.getFields()) {
                    if (!(object instanceof ClientIdentifiable) || !(object instanceof ClientField)) continue;
                    fields.add((ClientField)object);
                }
            }
            if (this.select.getDistinctFields() != null) {
                for (Object object : this.select.getDistinctFields()) {
                    if (!(object instanceof ClientIdentifiable) || !(object instanceof ClientField)) continue;
                    fields.add((ClientField)object);
                }
            }
        }
        if (this.getGroupBy() != null) {
            for (ClientAxis clientAxis : this.getGroupBy().getAxes()) {
                if (clientAxis == null) continue;
                for (Object field : clientAxis.getItems()) {
                    if (!(field instanceof ClientIdentifiable) || !(field instanceof ClientField)) continue;
                    fields.add((ClientField)field);
                }
            }
        }
        return fields;
    }

    public void accept(ClientQueryVisitor visitor) {
        if (visitor == null) {
            return;
        }
        if (this.select != null) {
            this.select.accept(visitor);
        }
        if (this.where != null) {
            this.where.accept(visitor);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClientQuery query = (ClientQuery)o;
        if (this.select != null ? !this.select.equals(query.select) : query.select != null) {
            return false;
        }
        if (this.from != null ? !this.from.equals(query.from) : query.from != null) {
            return false;
        }
        if (this.where != null ? !this.where.equals(query.where) : query.where != null) {
            return false;
        }
        if (this.getGroupBy() != null ? !this.getGroupBy().equals(query.getGroupBy()) : query.getGroupBy() != null) {
            return false;
        }
        if (this.getOrderBy() != null ? !this.getOrderBy().equals(query.getOrderBy()) : query.getOrderBy() != null) {
            return false;
        }
        return this.limit != null ? this.limit.equals(query.limit) : query.limit == null;
    }

    public int hashCode() {
        int result = this.select != null ? this.select.hashCode() : 0;
        result = 31 * result + (this.from != null ? this.from.hashCode() : 0);
        result = 31 * result + (this.where != null ? this.where.hashCode() : 0);
        result = 31 * result + (this.getGroupBy() != null ? this.getGroupBy().hashCode() : 0);
        result = 31 * result + (this.getOrderBy() != null ? this.getOrderBy().hashCode() : 0);
        result = 31 * result + (this.limit != null ? this.limit.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "ClientQuery{select=" + this.select + ", from=" + this.from + ", where=" + this.where + ", groupBy=" + this.getGroupBy() + ", orderBy=" + this.getOrderBy() + ", limit=" + this.limit + '}';
    }
}

