/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.dto.adhoc.query;

import com.jaspersoft.jasperserver.dto.adhoc.datasource.ClientDataSourceField;
import com.jaspersoft.jasperserver.dto.adhoc.query.ClientQuery;
import com.jaspersoft.jasperserver.dto.adhoc.query.ClientWhere;
import com.jaspersoft.jasperserver.dto.adhoc.query.el.ClientExpression;
import com.jaspersoft.jasperserver.dto.adhoc.query.el.ClientExpressionContainer;
import com.jaspersoft.jasperserver.dto.adhoc.query.field.ClientQueryAggregatedField;
import com.jaspersoft.jasperserver.dto.adhoc.query.field.ClientQueryField;
import com.jaspersoft.jasperserver.dto.adhoc.query.field.ClientQueryGroup;
import com.jaspersoft.jasperserver.dto.adhoc.query.order.ClientGenericOrder;
import com.jaspersoft.jasperserver.dto.adhoc.query.order.ClientOrder;
import com.jaspersoft.jasperserver.dto.adhoc.query.order.ClientPathOrder;
import com.jaspersoft.jasperserver.dto.adhoc.query.order.ClientTopOrBottomNOrder;
import com.jaspersoft.jasperserver.dto.adhoc.query.select.ClientSelect;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public abstract class ClientQueryBuilder {
    private List<ClientQueryField> fields;
    private List<ClientQueryField> distinctFields;
    private ClientExpression filters;
    private String filterExpression;
    private List<ClientOrder> order;
    private Map<String, ClientExpressionContainer> parameters;
    private Integer limit;

    public abstract ClientQuery build();

    @Deprecated
    public static ClientDataSourceField source(String name) {
        return new ClientDataSourceField().setName(name);
    }

    @Deprecated
    public static ClientDataSourceField source(String name, String type) {
        return ClientQueryBuilder.source(name).setType(type);
    }

    @Deprecated
    public static ClientQueryField field(ClientDataSourceField field) {
        return new ClientQueryField().setDataSourceField(field);
    }

    @Deprecated
    public static ClientQueryField field(String id, ClientDataSourceField field) {
        return new ClientQueryField().setId(id).setDataSourceField(field);
    }

    @Deprecated
    public static ClientQueryField field(String name) {
        return new ClientQueryField().setFieldName(name);
    }

    @Deprecated
    public static ClientQueryAggregatedField aggregatedField(ClientDataSourceField field, String aggregateExpression) {
        return new ClientQueryAggregatedField().setDataSourceField(field).setExpressionContainer(new ClientExpressionContainer(aggregateExpression));
    }

    @Deprecated
    public static ClientQueryAggregatedField aggregatedField(ClientDataSourceField field, ClientExpression aggregateExpression) {
        return new ClientQueryAggregatedField().setDataSourceField(field).setExpressionContainer(new ClientExpressionContainer(aggregateExpression));
    }

    @Deprecated
    public static ClientQueryAggregatedField aggregatedField(String id, String fieldName, String aggregateFunction) {
        return new ClientQueryAggregatedField().setId(id).setFieldReference(fieldName).setAggregateFunction(aggregateFunction);
    }

    @Deprecated
    public static ClientOrder asc(ClientDataSourceField dsField) {
        return new ClientGenericOrder().setFieldReference(dsField.getName()).setAscending(true);
    }

    @Deprecated
    public static ClientOrder asc(ClientQueryGroup queryField) {
        return new ClientGenericOrder().setAscending(true).setFieldReference(queryField.getId());
    }

    @Deprecated
    public static ClientOrder asc(String dsField) {
        return new ClientGenericOrder().setFieldReference(dsField).setAscending(true);
    }

    @Deprecated
    public static ClientOrder desc(ClientDataSourceField dsField) {
        return new ClientGenericOrder().setFieldReference(dsField.getName()).setAscending(false);
    }

    @Deprecated
    public static ClientOrder desc(ClientQueryGroup queryField) {
        return new ClientGenericOrder().setFieldReference(queryField.getId()).setAscending(false);
    }

    @Deprecated
    public static ClientOrder desc(String dsField) {
        return new ClientGenericOrder().setFieldReference(dsField).setAscending(false);
    }

    @Deprecated
    public static ClientOrder descAggLevel() {
        return new ClientGenericOrder().setAggregation(true).setAscending(false);
    }

    @Deprecated
    public static ClientOrder ascAggLevel() {
        return new ClientGenericOrder().setAggregation(true).setAscending(true);
    }

    @Deprecated
    public static ClientOrder ascByMember(List<String> path) {
        return new ClientPathOrder().setPath(path).setAscending(true);
    }

    @Deprecated
    public static ClientOrder descByMember(List<String> path) {
        return new ClientPathOrder().setPath(path).setAscending(false);
    }

    @Deprecated
    public static ClientTopOrBottomNOrder topN(List<String> path, int limit) {
        return new ClientTopOrBottomNOrder.ClientTopNOrder().setLimit(limit).setPath((List)path);
    }

    @Deprecated
    public static ClientTopOrBottomNOrder bottomN(List<String> path, int limit) {
        return new ClientTopOrBottomNOrder.ClientBottomNOrder().setLimit(limit).setPath((List)path);
    }

    @Deprecated
    public static ClientQueryGroup group(String id, String categorizer, ClientDataSourceField field) {
        return new ClientQueryGroup().setDataSourceField(field).setId(id).setCategorizer(categorizer);
    }

    @Deprecated
    public static ClientQueryGroup group(ClientDataSourceField field) {
        return new ClientQueryGroup().setDataSourceField(field);
    }

    @Deprecated
    public static ClientQueryGroup group(String id, ClientDataSourceField field) {
        return new ClientQueryGroup().setId(id).setDataSourceField(field);
    }

    @Deprecated
    public static ClientQueryGroup group(String fieldName, String categorizer) {
        return new ClientQueryGroup().setFieldName(fieldName).setCategorizer(categorizer);
    }

    @Deprecated
    public static ClientQueryGroup allGroup() {
        return new ClientQueryGroup.ClientAllGroup();
    }

    public ClientQueryBuilder where(ClientExpression filters) {
        this.setFilters(filters);
        return this;
    }

    public ClientQueryBuilder where(String expression) {
        this.setFilterExpression(expression);
        return this;
    }

    public ClientQueryBuilder where(Map<String, ClientExpressionContainer> parameters) {
        this.setParameters(parameters);
        return this;
    }

    public ClientQueryBuilder orderBy(ClientOrder ... order) {
        this.setOrder(Arrays.asList(order));
        return this;
    }

    public ClientQueryBuilder where(ClientExpression filters, Map<String, ClientExpressionContainer> parameters) {
        this.where(filters);
        this.setParameters(parameters);
        return this;
    }

    public ClientQueryBuilder limit(Integer limit) {
        this.setLimit(limit);
        return this;
    }

    protected ClientQuery buildCommon(ClientQuery query) {
        ClientSelect select = new ClientSelect();
        if (this.getFields() != null) {
            select.setFields(this.getFields());
        }
        if (this.getDistinctFields() != null) {
            select.setDistinctFields(this.getDistinctFields());
        }
        query.setSelect(select);
        if (this.getFilterExpression() != null) {
            query.setWhere(new ClientWhere(new ClientExpressionContainer(this.getFilterExpression())));
        }
        if (this.getFilters() != null) {
            query.setWhere(new ClientWhere(this.getFilters()));
        }
        if (this.getParameters() != null) {
            if (query.getWhere() == null) {
                query.setWhere(new ClientWhere(this.getParameters()));
            } else {
                query.getWhere().setParameters(this.getParameters());
            }
        }
        query.setLimit(this.getLimit());
        return query;
    }

    protected List<ClientQueryField> getFields() {
        return this.fields;
    }

    protected void setFields(List<ClientQueryField> fields) {
        this.fields = fields;
    }

    protected List<ClientQueryField> getDistinctFields() {
        return this.distinctFields;
    }

    protected void setDistinctFields(List<ClientQueryField> distinctFields) {
        this.distinctFields = distinctFields;
    }

    protected ClientExpression getFilters() {
        return this.filters;
    }

    protected void setFilters(ClientExpression filters) {
        this.filters = filters;
    }

    protected String getFilterExpression() {
        return this.filterExpression;
    }

    protected void setFilterExpression(String filterExpression) {
        this.filterExpression = filterExpression;
    }

    protected Map<String, ClientExpressionContainer> getParameters() {
        return this.parameters;
    }

    protected void setParameters(Map<String, ClientExpressionContainer> parameters) {
        this.parameters = parameters;
    }

    protected List<? extends ClientOrder> getOrder() {
        return this.order;
    }

    protected void setOrder(List<ClientOrder> order) {
        this.order = order;
    }

    protected Integer getLimit() {
        return this.limit;
    }

    protected void setLimit(Integer limit) {
        this.limit = limit;
    }
}

