/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.dto.adhoc.query;

import com.jaspersoft.jasperserver.dto.adhoc.query.ast.ClientQueryClause;
import com.jaspersoft.jasperserver.dto.adhoc.query.ast.ClientQueryVisitor;
import com.jaspersoft.jasperserver.dto.adhoc.query.el.ClientExpression;
import com.jaspersoft.jasperserver.dto.adhoc.query.el.ClientExpressionContainer;
import com.jaspersoft.jasperserver.dto.adhoc.query.el.ClientList;
import com.jaspersoft.jasperserver.dto.adhoc.query.el.ParameterExpressionsMapXmlAdapter;
import com.jaspersoft.jasperserver.dto.adhoc.query.el.literal.ClientBoolean;
import com.jaspersoft.jasperserver.dto.adhoc.query.el.literal.ClientDate;
import com.jaspersoft.jasperserver.dto.adhoc.query.el.literal.ClientNull;
import com.jaspersoft.jasperserver.dto.adhoc.query.el.literal.ClientNumber;
import com.jaspersoft.jasperserver.dto.adhoc.query.el.literal.ClientRelativeDateRange;
import com.jaspersoft.jasperserver.dto.adhoc.query.el.literal.ClientRelativeTimestampRange;
import com.jaspersoft.jasperserver.dto.adhoc.query.el.literal.ClientString;
import com.jaspersoft.jasperserver.dto.adhoc.query.el.literal.ClientTime;
import com.jaspersoft.jasperserver.dto.adhoc.query.el.literal.ClientTimestamp;
import com.jaspersoft.jasperserver.dto.adhoc.query.el.operator.ClientFunction;
import com.jaspersoft.jasperserver.dto.adhoc.query.el.operator.comparison.ClientEquals;
import com.jaspersoft.jasperserver.dto.adhoc.query.el.operator.comparison.ClientGreater;
import com.jaspersoft.jasperserver.dto.adhoc.query.el.operator.comparison.ClientGreaterOrEqual;
import com.jaspersoft.jasperserver.dto.adhoc.query.el.operator.comparison.ClientLess;
import com.jaspersoft.jasperserver.dto.adhoc.query.el.operator.comparison.ClientLessOrEqual;
import com.jaspersoft.jasperserver.dto.adhoc.query.el.operator.comparison.ClientNotEqual;
import com.jaspersoft.jasperserver.dto.adhoc.query.el.operator.logical.ClientAnd;
import com.jaspersoft.jasperserver.dto.adhoc.query.el.operator.logical.ClientNot;
import com.jaspersoft.jasperserver.dto.adhoc.query.el.operator.logical.ClientOr;
import com.jaspersoft.jasperserver.dto.adhoc.query.el.operator.membership.ClientIn;
import com.jaspersoft.jasperserver.dto.adhoc.query.validation.CheckExpressionType;
import com.jaspersoft.jasperserver.dto.adhoc.query.validation.CheckParametersExpressionContainer;
import com.jaspersoft.jasperserver.dto.adhoc.query.validation.ParameterMap;
import com.jaspersoft.jasperserver.dto.common.DeepCloneable;
import com.jaspersoft.jasperserver.dto.utils.ValueObjectUtils;
import java.io.Serializable;
import java.util.Map;
import javax.validation.Valid;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

@XmlRootElement(name="where")
public class ClientWhere
implements ClientQueryClause,
DeepCloneable<ClientWhere>,
Serializable {
    @CheckExpressionType(value={ClientNot.class, ClientAnd.class, ClientOr.class, ClientGreater.class, ClientGreaterOrEqual.class, ClientLess.class, ClientLessOrEqual.class, ClientNotEqual.class, ClientEquals.class, ClientFunction.class, ClientIn.class, ClientList.class})
    @Valid
    private ClientExpressionContainer filterExpression;
    @ParameterMap
    @CheckParametersExpressionContainer(value={ClientNull.class, ClientBoolean.class, ClientNumber.class, ClientString.class, ClientDate.class, ClientTime.class, ClientTimestamp.class, ClientList.class, ClientRelativeDateRange.class, ClientRelativeTimestampRange.class})
    @Valid
    private Map<String, ClientExpressionContainer> parameters;

    public ClientWhere() {
    }

    public ClientWhere(ClientWhere where) {
        ValueObjectUtils.checkNotNull(where);
        this.filterExpression = ValueObjectUtils.copyOf(where.getFilterExpression());
        this.parameters = ValueObjectUtils.copyOf(where.getParameters());
    }

    public ClientWhere(ClientExpressionContainer container) {
        this.filterExpression = container;
    }

    public ClientWhere(ClientExpression filters) {
        if (filters != null) {
            this.filterExpression = new ClientExpressionContainer().setObject(filters);
        }
    }

    public ClientWhere(String expression) {
        if (expression != null) {
            this.filterExpression = new ClientExpressionContainer().setString(expression);
        }
    }

    public ClientWhere(Map<String, ClientExpressionContainer> parameters) {
        this.parameters = parameters;
    }

    public ClientWhere(ClientExpression filters, Map<String, ClientExpressionContainer> parameters) {
        if (filters != null) {
            this.filterExpression = new ClientExpressionContainer().setObject(filters);
        }
        this.parameters = parameters;
    }

    public ClientExpressionContainer getFilterExpression() {
        return this.filterExpression;
    }

    public ClientWhere setFilterExpression(ClientExpressionContainer filterExpression) {
        this.filterExpression = filterExpression;
        return this;
    }

    @XmlJavaTypeAdapter(value=ParameterExpressionsMapXmlAdapter.class)
    public Map<String, ClientExpressionContainer> getParameters() {
        return this.parameters;
    }

    @ParameterMap
    public ClientWhere setParameters(Map<String, ClientExpressionContainer> parameters) {
        this.parameters = parameters;
        return this;
    }

    public void accept(ClientQueryVisitor visitor) {
        if (this.filterExpression != null && this.filterExpression.getObject() != null) {
            this.filterExpression.getObject().accept(visitor);
        }
        visitor.visit(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClientWhere that = (ClientWhere)o;
        if (this.filterExpression != null ? !this.filterExpression.equals(that.filterExpression) : that.filterExpression != null) {
            return false;
        }
        return !(this.parameters == null ? that.parameters != null : !this.parameters.equals(that.parameters));
    }

    public int hashCode() {
        int result = this.filterExpression != null ? this.filterExpression.hashCode() : 0;
        result = 31 * result + (this.parameters != null ? this.parameters.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "ClientWhere{filterExpression=" + this.filterExpression + ", parameters=" + this.parameters + '}';
    }

    @Override
    public ClientWhere deepClone() {
        return new ClientWhere(this);
    }
}

