/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.dto.adhoc.query;

import com.jaspersoft.jasperserver.dto.adhoc.datasource.ClientDataSourceField;
import com.jaspersoft.jasperserver.dto.adhoc.datasource.ClientDataSourceLevel;
import com.jaspersoft.jasperserver.dto.adhoc.query.ClientIdentifiable;
import com.jaspersoft.jasperserver.dto.adhoc.query.ClientMultiAxisQuery;
import com.jaspersoft.jasperserver.dto.adhoc.query.ClientQueryBuilder;
import com.jaspersoft.jasperserver.dto.adhoc.query.expansion.ClientExpandable;
import com.jaspersoft.jasperserver.dto.adhoc.query.expansion.ClientLevelExpansion;
import com.jaspersoft.jasperserver.dto.adhoc.query.expansion.ClientMemberExpansion;
import com.jaspersoft.jasperserver.dto.adhoc.query.field.ClientQueryAggregatedField;
import com.jaspersoft.jasperserver.dto.adhoc.query.field.ClientQueryLevel;
import com.jaspersoft.jasperserver.dto.adhoc.query.group.ClientMultiAxisGroupBy;
import com.jaspersoft.jasperserver.dto.adhoc.query.group.axis.ClientGroupAxisEnum;
import com.jaspersoft.jasperserver.dto.adhoc.query.group.axis.ClientLevelAxis;
import com.jaspersoft.jasperserver.dto.adhoc.query.order.ClientOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class MultiAxisQueryBuilder
extends ClientQueryBuilder {
    private List<ClientQueryAggregatedField> aggregates;
    private List<? extends ClientQueryLevel> rowLevels;
    private List<? extends ClientQueryLevel> columnLevels;
    private List<ClientExpandable> rowExpansions;
    private List<ClientExpandable> columnExpansions;

    public static MultiAxisQueryBuilder select(List<ClientQueryAggregatedField> aggregates) {
        MultiAxisQueryBuilder qb = new MultiAxisQueryBuilder();
        qb.setAggregates(aggregates);
        return qb;
    }

    public static MultiAxisQueryBuilder select() {
        return MultiAxisQueryBuilder.select(Collections.emptyList());
    }

    public static MultiAxisQueryBuilder select(ClientQueryAggregatedField ... aggregates) {
        return MultiAxisQueryBuilder.select(Arrays.asList(aggregates));
    }

    public static MultiAxisQueryBuilder select(ClientDataSourceField ... dataSourceFields) {
        ArrayList<ClientQueryAggregatedField> aggregates = new ArrayList<ClientQueryAggregatedField>();
        for (ClientDataSourceField dsField : dataSourceFields) {
            aggregates.add(new ClientQueryAggregatedField().setDataSourceField(dsField));
        }
        return MultiAxisQueryBuilder.select(aggregates);
    }

    @Override
    public ClientMultiAxisQuery build() {
        ClientMultiAxisQuery query = new ClientMultiAxisQuery();
        this.buildCommon(query);
        if (this.getAggregates() != null) {
            query.getSelect().setAggregations(this.getAggregates());
        }
        if (this.rowLevels != null || this.columnLevels != null) {
            ClientMultiAxisGroupBy groupBy = new ClientMultiAxisGroupBy();
            if (this.rowLevels != null) {
                groupBy.addAxis(ClientGroupAxisEnum.ROWS, new ClientLevelAxis(this.rowLevels, this.rowExpansions));
            }
            if (this.columnLevels != null) {
                groupBy.addAxis(ClientGroupAxisEnum.COLUMNS, new ClientLevelAxis(this.columnLevels, this.columnExpansions));
            }
            query.setGroupBy(groupBy);
        }
        if (this.getOrder() != null) {
            query.setOrderBy(this.getOrder());
        }
        return query;
    }

    public static ClientDataSourceLevel sourceLevel(String levelName, String dimensionName) {
        ClientDataSourceLevel sourceLevel = new ClientDataSourceLevel();
        sourceLevel.setName(levelName);
        sourceLevel.setDimensionName(dimensionName);
        return sourceLevel;
    }

    public MultiAxisQueryBuilder groupByRows(ClientQueryLevel ... cityDSLevel) {
        this.setRowLevels(Arrays.asList(cityDSLevel));
        return this;
    }

    public MultiAxisQueryBuilder groupByColumns(ClientQueryLevel ... cityDSLevel) {
        this.setColumnLevels(Arrays.asList(cityDSLevel));
        return this;
    }

    public MultiAxisQueryBuilder expandInRows(ClientExpandable ... expansions) {
        this.setRowExpansions(Arrays.asList(expansions));
        return this;
    }

    public MultiAxisQueryBuilder expandInRows(String ... ids) {
        ArrayList<ClientExpandable> expansions = new ArrayList<ClientExpandable>();
        for (String id : ids) {
            expansions.add(MultiAxisQueryBuilder.expansion(id, true));
        }
        this.setRowExpansions(expansions);
        return this;
    }

    public MultiAxisQueryBuilder expandInRows(ClientIdentifiable<String> ... identifiables) {
        if (identifiables == null) {
            throw new IllegalArgumentException("Specify at least one level to expand");
        }
        ArrayList<String> ids = new ArrayList<String>();
        for (ClientIdentifiable<String> identifiable : identifiables) {
            ids.add(identifiable.getId());
        }
        return this.expandInRows(ids.toArray(new String[ids.size()]));
    }

    public MultiAxisQueryBuilder expandInColumns(ClientExpandable ... expansions) {
        this.setColumnExpansions(Arrays.asList(expansions));
        return this;
    }

    public MultiAxisQueryBuilder expandInColumns(String ... ids) {
        ArrayList<ClientExpandable> expansions = new ArrayList<ClientExpandable>();
        for (String id : ids) {
            expansions.add(MultiAxisQueryBuilder.expansion(id, true));
        }
        this.setColumnExpansions(expansions);
        return this;
    }

    public MultiAxisQueryBuilder collapseInColumns(String ... ids) {
        ArrayList<ClientExpandable> expansions = new ArrayList<ClientExpandable>();
        for (String id : ids) {
            expansions.add(MultiAxisQueryBuilder.expansion(id, false));
        }
        this.setColumnExpansions(expansions);
        return this;
    }

    public MultiAxisQueryBuilder collapseInRows(String ... ids) {
        ArrayList<ClientExpandable> expansions = new ArrayList<ClientExpandable>();
        for (String id : ids) {
            expansions.add(MultiAxisQueryBuilder.expansion(id, false));
        }
        this.setRowExpansions(expansions);
        return this;
    }

    @Override
    public MultiAxisQueryBuilder orderBy(ClientOrder ... order) {
        return (MultiAxisQueryBuilder)super.orderBy(order);
    }

    @Override
    public MultiAxisQueryBuilder limit(Integer limit) {
        return (MultiAxisQueryBuilder)super.limit(limit);
    }

    protected List<ClientQueryAggregatedField> getAggregates() {
        return this.aggregates;
    }

    protected void setAggregates(List<ClientQueryAggregatedField> aggregates) {
        this.aggregates = aggregates;
    }

    public List<? extends ClientQueryLevel> getColumnLevels() {
        return this.columnLevels;
    }

    public void setColumnLevels(List<? extends ClientQueryLevel> columnLevels) {
        this.columnLevels = columnLevels;
    }

    public List<? extends ClientQueryLevel> getRowLevels() {
        return this.rowLevels;
    }

    public void setRowLevels(List<? extends ClientQueryLevel> rowLevels) {
        this.rowLevels = rowLevels;
    }

    public List<? extends ClientExpandable> getColumnExpansions() {
        return this.columnExpansions;
    }

    public void setColumnExpansions(List<ClientExpandable> columnExpansions) {
        this.columnExpansions = columnExpansions;
    }

    public List<? extends ClientExpandable> getRowExpansions() {
        return this.rowExpansions;
    }

    public void setRowExpansions(List<ClientExpandable> rowExpansions) {
        this.rowExpansions = rowExpansions;
    }

    @Deprecated
    public static ClientQueryLevel level(String id, ClientDataSourceField dsLevel) {
        return new ClientQueryLevel().setId(id).setDataSourceField(dsLevel);
    }

    @Deprecated
    public static ClientQueryLevel level(String id, ClientDataSourceLevel dsLevel) {
        return new ClientQueryLevel().setId(id).setDataSourceField(dsLevel);
    }

    @Deprecated
    public static ClientQueryLevel level(String id, String fieldName, String categorizer) {
        return new ClientQueryLevel().setId(id).setFieldName(fieldName).setCategorizer(categorizer);
    }

    @Deprecated
    public static ClientQueryLevel level(ClientDataSourceField clientLevel) {
        return new ClientQueryLevel().setDataSourceField(clientLevel);
    }

    @Deprecated
    public static ClientQueryLevel level(ClientDataSourceLevel clientLevel) {
        return new ClientQueryLevel().setDataSourceField(clientLevel);
    }

    @Deprecated
    public static ClientQueryLevel allLevel(String fieldName, String dimension) {
        return new ClientQueryLevel.ClientAllLevel(dimension).setFieldName(fieldName);
    }

    @Deprecated
    public static ClientQueryLevel allLevel(String dimension) {
        return new ClientQueryLevel.ClientAllLevel(dimension);
    }

    public static ClientQueryLevel aggRef() {
        return new ClientQueryLevel.ClientLevelAggregationsRef();
    }

    public static ClientLevelExpansion expand(String id) {
        return new ClientLevelExpansion().setLevelReference(id).setExpanded(true);
    }

    public static ClientMemberExpansion expandMember(String id) {
        return new ClientMemberExpansion().setPath(MultiAxisQueryBuilder.sanitizePathList(Arrays.asList(id.split("/")))).setExpanded(true);
    }

    public static ClientLevelExpansion expandAggLevel() {
        return new ClientLevelExpansion().setAggregationLevel(true).setExpanded(true);
    }

    public static ClientLevelExpansion collapse(String id) {
        return new ClientLevelExpansion().setLevelReference(id).setExpanded(false);
    }

    public static ClientMemberExpansion collapseMember(String id) {
        return new ClientMemberExpansion().setPath(MultiAxisQueryBuilder.sanitizePathList(Arrays.asList(id.split("/")))).setExpanded(false);
    }

    public static ClientExpandable expansion(String id, boolean isExpanded) {
        ClientLevelExpansion expandable = id.startsWith("/") ? new ClientMemberExpansion().setPath(MultiAxisQueryBuilder.sanitizePathList(Arrays.asList(id.split("/")))) : new ClientLevelExpansion().setLevelReference(id);
        return expandable.setExpanded(isExpanded);
    }

    public static List<String> sanitizePathList(List<String> pathSegments) {
        ArrayList<String> sanitizedList = new ArrayList<String>();
        for (String pathSegment : pathSegments) {
            if (pathSegment == null || pathSegment.length() <= 0) continue;
            sanitizedList.add(pathSegment);
        }
        return sanitizedList;
    }
}

