/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.dto.adhoc.query;

import com.jaspersoft.jasperserver.dto.adhoc.query.ClientMultiLevelQuery;
import com.jaspersoft.jasperserver.dto.adhoc.query.ClientQueryBuilder;
import com.jaspersoft.jasperserver.dto.adhoc.query.el.ClientExpression;
import com.jaspersoft.jasperserver.dto.adhoc.query.el.ClientExpressionContainer;
import com.jaspersoft.jasperserver.dto.adhoc.query.field.ClientQueryAggregatedField;
import com.jaspersoft.jasperserver.dto.adhoc.query.field.ClientQueryField;
import com.jaspersoft.jasperserver.dto.adhoc.query.field.ClientQueryGroup;
import com.jaspersoft.jasperserver.dto.adhoc.query.group.ClientQueryGroupBy;
import com.jaspersoft.jasperserver.dto.adhoc.query.order.ClientOrder;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class MultiLevelQueryBuilder
extends ClientQueryBuilder {
    private List<? extends ClientQueryGroup> groups;
    private List<ClientQueryAggregatedField> aggregates;

    public static MultiLevelQueryBuilder select(List<ClientQueryField> fields) {
        MultiLevelQueryBuilder qb = new MultiLevelQueryBuilder();
        qb.setFields(fields);
        return qb;
    }

    public static MultiLevelQueryBuilder select(ClientQueryField ... fields) {
        return MultiLevelQueryBuilder.select(Arrays.asList(fields));
    }

    public static MultiLevelQueryBuilder select(List<ClientQueryField> fields, List<ClientQueryAggregatedField> aggregates) {
        MultiLevelQueryBuilder qb = MultiLevelQueryBuilder.select(fields);
        qb.setAggregates(aggregates);
        return qb;
    }

    public static MultiLevelQueryBuilder selectDistinct(List<ClientQueryField> distinctFields) {
        MultiLevelQueryBuilder qb = new MultiLevelQueryBuilder();
        qb.setDistinctFields(distinctFields);
        return qb;
    }

    public static MultiLevelQueryBuilder selectDistinct(ClientQueryField ... distinctFields) {
        return MultiLevelQueryBuilder.selectDistinct(Arrays.asList(distinctFields));
    }

    public static MultiLevelQueryBuilder selectDistinct(List<ClientQueryField> distinctFields, List<ClientQueryAggregatedField> aggregates) {
        MultiLevelQueryBuilder qb = MultiLevelQueryBuilder.selectDistinct(distinctFields);
        qb.setAggregates(aggregates);
        return qb;
    }

    @Override
    public ClientMultiLevelQuery build() {
        ClientMultiLevelQuery query = new ClientMultiLevelQuery();
        this.buildCommon(query);
        if (this.getAggregates() != null) {
            query.getSelect().setAggregations(this.getAggregates());
        }
        if (this.getGroups() != null) {
            query.setGroupBy(new ClientQueryGroupBy().setGroups(this.getGroups()));
        }
        if (this.getOrder() != null) {
            query.setOrderBy(this.getOrder());
        }
        return query;
    }

    @Override
    public MultiLevelQueryBuilder where(ClientExpression filters) {
        return (MultiLevelQueryBuilder)super.where(filters);
    }

    @Override
    public MultiLevelQueryBuilder where(String expression) {
        return (MultiLevelQueryBuilder)super.where(expression);
    }

    @Override
    public MultiLevelQueryBuilder where(Map<String, ClientExpressionContainer> parameters) {
        return (MultiLevelQueryBuilder)super.where(parameters);
    }

    @Override
    public MultiLevelQueryBuilder where(ClientExpression filters, Map<String, ClientExpressionContainer> parameters) {
        return (MultiLevelQueryBuilder)super.where(filters, parameters);
    }

    @Override
    public MultiLevelQueryBuilder orderBy(ClientOrder ... order) {
        return (MultiLevelQueryBuilder)super.orderBy(order);
    }

    public MultiLevelQueryBuilder aggregates(ClientQueryAggregatedField ... aggregatedFields) {
        this.setAggregates(Arrays.asList(aggregatedFields));
        return this;
    }

    public MultiLevelQueryBuilder groupBy(ClientQueryGroup ... groups) {
        this.setGroups(Arrays.asList(groups));
        return this;
    }

    protected List<? extends ClientQueryGroup> getGroups() {
        return this.groups;
    }

    protected void setGroups(List<? extends ClientQueryGroup> groups) {
        this.groups = groups;
    }

    protected List<ClientQueryAggregatedField> getAggregates() {
        return this.aggregates;
    }

    protected void setAggregates(List<ClientQueryAggregatedField> aggregates) {
        this.aggregates = aggregates;
    }
}

