/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.dto.adhoc.query;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class QueryPatternsUtil {
    public static final String NAME_2GROUPS = "\\s*(?:([\\S]+)|(?:[\"]([^\"]+)[\"]))\\s*";
    public static final String BY_GROUP = "(?:\\s*(?i)BY (.+))?";
    public static final String NAME_OPT_ALIAS_4GROUPS = "\\s*(?:([\\S]+)|(?:[\"]([^\"]+)[\"]))\\s*(?:(?i)AS\\s*(?:([\\S]+)|(?:[\"]([^\"]+)[\"]))\\s*)?";
    public static final Pattern NAME_OPT_ALIAS_4GROUPS_PATTERN = Pattern.compile("\\s*(?:([\\S]+)|(?:[\"]([^\"]+)[\"]))\\s*(?:(?i)AS\\s*(?:([\\S]+)|(?:[\"]([^\"]+)[\"]))\\s*)?");
    public static final String NAME_OPT_ALIAS_OPT_EXPRESSION_5GROUPS = "\\s*(?:([\\S]+)|(?:[\"]([^\"]+)[\"]))\\s*(?:(?i)AS\\s*(?:([\\S]+)|(?:[\"]([^\"]+)[\"]))\\s*)?(?:\\s*(?i)BY (.+))?";
    public static final Pattern NAME_OPT_ALIAS_OPT_EXPRESSION_5GROUPS_PATTERN = Pattern.compile("\\s*(?:([\\S]+)|(?:[\"]([^\"]+)[\"]))\\s*(?:(?i)AS\\s*(?:([\\S]+)|(?:[\"]([^\"]+)[\"]))\\s*)?(?:\\s*(?i)BY (.+))?");
    public static final String ORDER_4GROUPS = "\\s*(?:([\\S]+)|(?:[\"]([^\"]+)[\"]))\\s*(?:\\s*(?i)BY (.+))?(?: ((?i)ASC|DESC)\\s*)";
    public static final Pattern ORDER_4GROUPS_PATTERN = Pattern.compile("\\s*(?:([\\S]+)|(?:[\"]([^\"]+)[\"]))\\s*(?:\\s*(?i)BY (.+))?(?: ((?i)ASC|DESC)\\s*)");
    public static final String ORDER_4GROUPS2 = "\\s*(?:([\\S]+)|(?:[\"]([^\"]+)[\"]))\\s*(?:\\s*(?i)BY (.+))?";
    public static final Pattern ORDER_4GROUPS_PATTERN2 = Pattern.compile("\\s*(?:([\\S]+)|(?:[\"]([^\"]+)[\"]))\\s*(?:\\s*(?i)BY (.+))?");

    public static NameAliasExpression parseNameAliasExpression(String string) {
        NameAliasExpression nameAliasExpression = new NameAliasExpression();
        Matcher matcher = NAME_OPT_ALIAS_OPT_EXPRESSION_5GROUPS_PATTERN.matcher(string);
        if (matcher.matches()) {
            String expression;
            String alias;
            nameAliasExpression.name = matcher.group(1) != null ? matcher.group(1) : matcher.group(2);
            String string2 = alias = matcher.group(3) != null ? matcher.group(3) : matcher.group(4);
            if (alias != null) {
                nameAliasExpression.alias = alias;
            }
            if ((expression = matcher.group(5)) != null) {
                nameAliasExpression.expression = expression;
            }
        }
        return nameAliasExpression;
    }

    public static NameExpressionOrder parseNameExpressionOrder(String order) {
        NameExpressionOrder nameExpressionOrder = new NameExpressionOrder();
        Matcher matcher = ORDER_4GROUPS_PATTERN.matcher(order);
        if (matcher.matches()) {
            String trimOrder;
            nameExpressionOrder.name = matcher.group(1) != null ? matcher.group(1) : matcher.group(2);
            String expression = matcher.group(3);
            if (expression != null) {
                nameExpressionOrder.expression = expression;
            }
            if ((trimOrder = order.trim().toUpperCase()).endsWith("ASC")) {
                nameExpressionOrder.order = "ASC";
            } else if (trimOrder.endsWith("DESC")) {
                nameExpressionOrder.order = "DESC";
            }
        } else {
            matcher = ORDER_4GROUPS_PATTERN2.matcher(order);
            if (matcher.matches()) {
                nameExpressionOrder.name = matcher.group(1) != null ? matcher.group(1) : matcher.group(2);
                String expression = matcher.group(3);
                if (expression != null) {
                    nameExpressionOrder.expression = expression;
                }
                nameExpressionOrder.order = "ASC";
            }
        }
        return nameExpressionOrder;
    }

    public static class NameExpressionOrder {
        public String name;
        public String expression;
        public String order;
    }

    public static class NameAliasExpression {
        public String name;
        public String alias;
        public String expression;
    }

    public static class NameAlias {
        public String name;
        public String alias;
    }
}

