/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.dto.adhoc.query.adapter;

import com.jaspersoft.jasperserver.dto.adhoc.query.el.adapters.DomELCommonSimpleDateFormats;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.apache.commons.lang3.time.DateUtils;

public class ELTimestampAdapter
extends XmlAdapter<String, Timestamp> {
    private ThreadLocal<SimpleDateFormat> formatter = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return DomELCommonSimpleDateFormats.timestampFormat();
        }
    };
    private ThreadLocal<SimpleDateFormat> isoFormatter = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return DomELCommonSimpleDateFormats.isoTimestampFormat();
        }
    };

    public String marshal(Timestamp v) throws Exception {
        return this.isoFormatter.get().format(v);
    }

    public Timestamp unmarshal(String v) throws Exception {
        Date date;
        try {
            date = DateUtils.parseDate((String)v, (String[])new String[]{"yyyy-MM-dd'T'HH:mm:ss.SSS", "yyyy-MM-dd'T'HH:mm:ss", "yyyy-MM-dd HH:mm:ss.SSS", "yyyy-MM-dd HH:mm:ss"});
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Unable to parse given value for timestamp: " + v, e);
        }
        return new Timestamp(date.getTime());
    }

    public String isoMarshal(Timestamp v) throws Exception {
        return this.isoFormatter.get().format(v);
    }
}

