/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.dto.adhoc.query.el;

import com.jaspersoft.jasperserver.dto.adhoc.query.el.ClientExpression;
import com.jaspersoft.jasperserver.dto.adhoc.query.el.ClientLiteral;
import com.jaspersoft.jasperserver.dto.adhoc.query.el.ClientVariable;
import com.jaspersoft.jasperserver.dto.adhoc.query.el.literal.ClientBoolean;
import com.jaspersoft.jasperserver.dto.adhoc.query.el.literal.ClientDate;
import com.jaspersoft.jasperserver.dto.adhoc.query.el.literal.ClientNull;
import com.jaspersoft.jasperserver.dto.adhoc.query.el.literal.ClientNumber;
import com.jaspersoft.jasperserver.dto.adhoc.query.el.literal.ClientString;
import com.jaspersoft.jasperserver.dto.adhoc.query.el.literal.ClientTime;
import com.jaspersoft.jasperserver.dto.adhoc.query.el.literal.ClientTimestamp;
import com.jaspersoft.jasperserver.dto.adhoc.query.el.operator.ClientComparison;
import com.jaspersoft.jasperserver.dto.adhoc.query.el.operator.ClientFunction;
import com.jaspersoft.jasperserver.dto.adhoc.query.el.operator.ClientLogical;
import com.jaspersoft.jasperserver.dto.adhoc.query.el.operator.arithmetic.ClientAdd;
import com.jaspersoft.jasperserver.dto.adhoc.query.el.operator.arithmetic.ClientDivide;
import com.jaspersoft.jasperserver.dto.adhoc.query.el.operator.arithmetic.ClientMultiply;
import com.jaspersoft.jasperserver.dto.adhoc.query.el.operator.arithmetic.ClientPercentRatio;
import com.jaspersoft.jasperserver.dto.adhoc.query.el.operator.arithmetic.ClientSubtract;
import com.jaspersoft.jasperserver.dto.adhoc.query.el.operator.logical.ClientAnd;
import com.jaspersoft.jasperserver.dto.adhoc.query.el.operator.logical.ClientNot;
import com.jaspersoft.jasperserver.dto.adhoc.query.el.operator.logical.ClientOr;
import com.jaspersoft.jasperserver.dto.adhoc.query.el.operator.membership.ClientIn;
import com.jaspersoft.jasperserver.dto.adhoc.query.el.range.ClientRange;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

public class ClientExpressions {
    public static final String EQUALS_DATE_FUN = "equalsDate";
    public static final String AFTER_DATE_FUN = "afterDate";
    public static final String BEFORE_DATE_FUN = "beforeDate";
    public static final String IS_ON_OR_AFTER_DATE_FUN = "isOnOrAfterDate";
    public static final String IS_ON_OR_BEFORE_DATE_FUN = "isOnOrBeforeDate";
    public static final String BETWEEN_DATE_FUN = "betweenDates";
    public static final String STARTS_WITH_FUN = "startsWith";
    public static final String ENDS_WITH_FUN = "endsWith";
    public static final String CONTAINS_FUN = "contains";
    public static final String MISSING_REPRESENTATION = "$missing$";

    public static ClientFunction function(String name, ClientExpression ... params) {
        return new ClientFunction(name, ClientExpressions.list(params));
    }

    public static ClientFunction function(String name, List<ClientExpression> params) {
        return new ClientFunction(name, params);
    }

    public static ClientFunction equalsDate(ClientExpression ... params) {
        return new ClientFunction(EQUALS_DATE_FUN, ClientExpressions.list(params));
    }

    public static ClientFunction afterDate(ClientExpression ... params) {
        return new ClientFunction(AFTER_DATE_FUN, ClientExpressions.list(params));
    }

    public static ClientFunction beforeDate(ClientExpression ... params) {
        return new ClientFunction(BEFORE_DATE_FUN, ClientExpressions.list(params));
    }

    public static ClientFunction betweenDates(ClientExpression ... params) {
        return new ClientFunction(BETWEEN_DATE_FUN, ClientExpressions.list(params));
    }

    public static ClientFunction startsWith(ClientExpression ... params) {
        return new ClientFunction(STARTS_WITH_FUN, ClientExpressions.list(params));
    }

    public static ClientFunction endsWith(ClientExpression ... params) {
        return new ClientFunction(ENDS_WITH_FUN, ClientExpressions.list(params));
    }

    public static ClientFunction contains(ClientExpression ... params) {
        return new ClientFunction(CONTAINS_FUN, ClientExpressions.list(params));
    }

    public static ClientLiteral nullLiteral() {
        return new ClientNull();
    }

    public static ClientLiteral literal(String value) {
        return new ClientString(value);
    }

    public static ClientLiteral literal(Byte value) {
        return new ClientNumber(value);
    }

    public static ClientLiteral literal(Short value) {
        return new ClientNumber(value);
    }

    public static ClientLiteral literal(Integer value) {
        return new ClientNumber(value);
    }

    public static ClientLiteral literal(Long value) {
        return new ClientNumber(value);
    }

    public static ClientLiteral literal(BigInteger value) {
        return new ClientNumber(value);
    }

    public static ClientLiteral literal(Float value) {
        return new ClientNumber(value);
    }

    public static ClientLiteral literal(Double value) {
        return new ClientNumber(value);
    }

    public static ClientLiteral literal(BigDecimal value) {
        return new ClientNumber(value);
    }

    public static ClientLiteral literal(Date value) {
        return new ClientDate(value);
    }

    public static ClientLiteral literal(Time value) {
        return new ClientTime(value);
    }

    public static ClientLiteral literal(Timestamp date) {
        return new ClientTimestamp(date);
    }

    public static ClientLiteral literal(boolean value) {
        return new ClientBoolean(value);
    }

    public static ClientLiteral literal(char value) {
        return new ClientString(String.valueOf(value));
    }

    public static ClientLiteral string(String value) {
        return ClientExpressions.literal(value);
    }

    public static ClientLiteral integer(Integer value) {
        return ClientExpressions.literal(value);
    }

    public static ClientLiteral decimal(BigDecimal value) {
        return ClientExpressions.literal(value);
    }

    public static ClientLiteral decimal(Double value) {
        return ClientExpressions.literal(value);
    }

    public static ClientLiteral date(Date value) {
        return ClientExpressions.literal(value);
    }

    public static ClientLiteral time(Time value) {
        return ClientExpressions.literal(value);
    }

    public static ClientLiteral timestamp(Timestamp value) {
        return ClientExpressions.literal(value);
    }

    public static ClientLiteral bool(boolean value) {
        return ClientExpressions.literal(value);
    }

    public static ClientLiteral character(char value) {
        return ClientExpressions.literal(value);
    }

    public static ClientRange range(ClientExpression start, ClientExpression end) {
        return new ClientRange(start, end);
    }

    public static ClientRange range(ClientVariable start, ClientVariable end) {
        return new ClientRange(start, end);
    }

    public static ClientRange range(Integer start, Integer end) {
        return new ClientRange(ClientExpressions.literal(start), ClientExpressions.literal(end));
    }

    public static ClientRange range(Time start, Time end) {
        return new ClientRange(ClientExpressions.literal(start), ClientExpressions.literal(end));
    }

    public static ClientRange range(Double start, Double end) {
        return new ClientRange(ClientExpressions.literal(start), ClientExpressions.literal(end));
    }

    public static ClientRange range(BigDecimal start, BigDecimal end) {
        return new ClientRange(ClientExpressions.literal(start), ClientExpressions.literal(end));
    }

    public static ClientRange range(String start, String end) {
        return new ClientRange(ClientExpressions.literal(start), ClientExpressions.literal(end));
    }

    public static ClientVariable variable(String string) {
        return new ClientVariable(string);
    }

    public static ClientNumber number(Number number) {
        return new ClientNumber(number);
    }

    public static ClientNot not(ClientExpression expression) {
        return new ClientNot(expression);
    }

    public static ClientAnd and(ClientExpression lhs, ClientExpression rhs) {
        return ClientLogical.and(lhs, rhs);
    }

    public static ClientIn in(ClientExpression lhs, ClientExpression rhs) {
        return new ClientIn(lhs, rhs);
    }

    public static ClientOr or(ClientExpression lhs, ClientExpression rhs) {
        return ClientLogical.or(lhs, rhs);
    }

    public static ClientComparison comparison(String operation, ClientExpression ... operands) {
        return ClientComparison.createComparison(operation, ClientExpressions.list(operands));
    }

    public static ClientComparison comparison(String operation, List<ClientExpression> operands) {
        return ClientComparison.createComparison(operation, operands);
    }

    public static List<ClientExpression> list(ClientExpression ... operands) {
        return Arrays.asList(operands);
    }

    public static List<ClientExpression> operands(ClientExpression ... operands) {
        return Arrays.asList(operands);
    }

    public static List<ClientExpression> args(ClientExpression ... operands) {
        return Arrays.asList(operands);
    }

    public static ClientRange range(ClientLiteral start, ClientLiteral end) {
        return new ClientRange(start, end);
    }

    public static ClientAdd add(ClientExpression lhs, ClientExpression rhs) {
        return (ClientAdd)new ClientAdd().setOperands(Arrays.asList(lhs, rhs));
    }

    public static ClientMultiply multiply(ClientExpression lhs, ClientExpression rhs) {
        return (ClientMultiply)new ClientMultiply().setOperands(Arrays.asList(lhs, rhs));
    }

    public static ClientSubtract subtract(ClientExpression lhs, ClientExpression rhs) {
        return (ClientSubtract)new ClientSubtract().setOperands(Arrays.asList(lhs, rhs));
    }

    public static ClientDivide divide(ClientExpression lhs, ClientExpression rhs) {
        return (ClientDivide)new ClientDivide().setOperands(Arrays.asList(lhs, rhs));
    }

    public static ClientPercentRatio percentRatio(ClientExpression lhs, ClientExpression rhs) {
        return (ClientPercentRatio)new ClientPercentRatio().setOperands(Arrays.asList(lhs, rhs));
    }
}

