/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.dto.adhoc.query.el;

import com.jaspersoft.jasperserver.dto.adhoc.query.el.ClientExpression;
import com.jaspersoft.jasperserver.dto.adhoc.query.el.ClientVariable;
import com.jaspersoft.jasperserver.dto.adhoc.query.el.ast.ClientELVisitor;
import com.jaspersoft.jasperserver.dto.adhoc.query.el.literal.ClientBoolean;
import com.jaspersoft.jasperserver.dto.adhoc.query.el.literal.ClientDate;
import com.jaspersoft.jasperserver.dto.adhoc.query.el.literal.ClientNull;
import com.jaspersoft.jasperserver.dto.adhoc.query.el.literal.ClientNumber;
import com.jaspersoft.jasperserver.dto.adhoc.query.el.literal.ClientRelativeDateRange;
import com.jaspersoft.jasperserver.dto.adhoc.query.el.literal.ClientRelativeTimestampRange;
import com.jaspersoft.jasperserver.dto.adhoc.query.el.literal.ClientString;
import com.jaspersoft.jasperserver.dto.adhoc.query.el.literal.ClientTime;
import com.jaspersoft.jasperserver.dto.adhoc.query.el.literal.ClientTimestamp;
import com.jaspersoft.jasperserver.dto.adhoc.query.el.operator.ClientFunction;
import com.jaspersoft.jasperserver.dto.adhoc.query.el.operator.arithmetic.ClientAdd;
import com.jaspersoft.jasperserver.dto.adhoc.query.el.operator.arithmetic.ClientDivide;
import com.jaspersoft.jasperserver.dto.adhoc.query.el.operator.arithmetic.ClientMultiply;
import com.jaspersoft.jasperserver.dto.adhoc.query.el.operator.arithmetic.ClientPercentRatio;
import com.jaspersoft.jasperserver.dto.adhoc.query.el.operator.arithmetic.ClientSubtract;
import com.jaspersoft.jasperserver.dto.adhoc.query.el.operator.comparison.ClientEquals;
import com.jaspersoft.jasperserver.dto.adhoc.query.el.operator.comparison.ClientGreater;
import com.jaspersoft.jasperserver.dto.adhoc.query.el.operator.comparison.ClientGreaterOrEqual;
import com.jaspersoft.jasperserver.dto.adhoc.query.el.operator.comparison.ClientLess;
import com.jaspersoft.jasperserver.dto.adhoc.query.el.operator.comparison.ClientLessOrEqual;
import com.jaspersoft.jasperserver.dto.adhoc.query.el.operator.comparison.ClientNotEqual;
import com.jaspersoft.jasperserver.dto.adhoc.query.el.operator.logical.ClientAnd;
import com.jaspersoft.jasperserver.dto.adhoc.query.el.operator.logical.ClientNot;
import com.jaspersoft.jasperserver.dto.adhoc.query.el.operator.logical.ClientOr;
import com.jaspersoft.jasperserver.dto.adhoc.query.el.operator.membership.ClientIn;
import com.jaspersoft.jasperserver.dto.adhoc.query.el.range.ClientRange;
import com.jaspersoft.jasperserver.dto.utils.ValueObjectUtils;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="list")
@XmlAccessorType(value=XmlAccessType.PROPERTY)
public class ClientList
implements ClientExpression<ClientList> {
    public static final String EXPRESSION_ID = "list";
    public List<ClientExpression> items;

    public ClientList() {
        this.items = new ArrayList<ClientExpression>();
    }

    public ClientList(List<ClientExpression> expressions) {
        this();
        if (expressions != null) {
            this.items = ValueObjectUtils.copyOf(expressions);
        }
    }

    public ClientList(ClientList source) {
        ValueObjectUtils.checkNotNull(source);
        this.items = ValueObjectUtils.copyOf(source.getItems());
    }

    public ClientList addItem(ClientExpression expr) {
        this.items.add(expr);
        return this;
    }

    public ClientList deleteItem(ClientExpression expr) {
        this.items.remove(expr);
        return this;
    }

    @Override
    public void accept(ClientELVisitor visitor) {
        if (this.items != null) {
            for (ClientExpression expr : this.items) {
                expr.accept(visitor);
            }
        }
        visitor.visit(this);
    }

    @XmlElementWrapper(name="items")
    @XmlElements(value={@XmlElement(name="NULL", type=ClientNull.class), @XmlElement(name="boolean", type=ClientBoolean.class), @XmlElement(name="number", type=ClientNumber.class), @XmlElement(name="relativeDateRange", type=ClientRelativeDateRange.class), @XmlElement(name="relativeTimestampRange", type=ClientRelativeTimestampRange.class), @XmlElement(name="string", type=ClientString.class), @XmlElement(name="date", type=ClientDate.class), @XmlElement(name="time", type=ClientTime.class), @XmlElement(name="timestamp", type=ClientTimestamp.class), @XmlElement(name="variable", type=ClientVariable.class), @XmlElement(name="not", type=ClientNot.class), @XmlElement(name="and", type=ClientAnd.class), @XmlElement(name="or", type=ClientOr.class), @XmlElement(name="greater", type=ClientGreater.class), @XmlElement(name="greaterOrEqual", type=ClientGreaterOrEqual.class), @XmlElement(name="less", type=ClientLess.class), @XmlElement(name="lessOrEqual", type=ClientLessOrEqual.class), @XmlElement(name="notEqual", type=ClientNotEqual.class), @XmlElement(name="equals", type=ClientEquals.class), @XmlElement(name="function", type=ClientFunction.class), @XmlElement(name="in", type=ClientIn.class), @XmlElement(name="range", type=ClientRange.class), @XmlElement(name="add", type=ClientAdd.class), @XmlElement(name="subtract", type=ClientSubtract.class), @XmlElement(name="multiply", type=ClientMultiply.class), @XmlElement(name="divide", type=ClientDivide.class), @XmlElement(name="percentRatio", type=ClientPercentRatio.class), @XmlElement(name="list", type=ClientList.class)})
    public List<ClientExpression> getItems() {
        return this.items;
    }

    public ClientList setItems(List<ClientExpression> items) {
        this.items = items;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClientList that = (ClientList)o;
        return this.items != null ? this.items.equals(that.items) : that.items == null;
    }

    public int hashCode() {
        return this.items != null ? this.items.hashCode() : 0;
    }

    public String toString() {
        if (this.items == null || this.items.isEmpty()) {
            return "()";
        }
        StringBuilder sb = new StringBuilder("(");
        boolean isFirst = true;
        for (ClientExpression expression : this.items) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(", ");
            }
            sb.append(expression.toString());
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public ClientList deepClone() {
        return new ClientList(this);
    }
}

