/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.dto.adhoc.query.el;

import com.jaspersoft.jasperserver.dto.adhoc.query.el.ClientExpression;
import com.jaspersoft.jasperserver.dto.adhoc.query.el.ClientList;
import com.jaspersoft.jasperserver.dto.adhoc.query.el.ClientVariable;
import com.jaspersoft.jasperserver.dto.adhoc.query.el.ast.ClientELVisitor;
import com.jaspersoft.jasperserver.dto.adhoc.query.el.literal.ClientBoolean;
import com.jaspersoft.jasperserver.dto.adhoc.query.el.literal.ClientDate;
import com.jaspersoft.jasperserver.dto.adhoc.query.el.literal.ClientNull;
import com.jaspersoft.jasperserver.dto.adhoc.query.el.literal.ClientNumber;
import com.jaspersoft.jasperserver.dto.adhoc.query.el.literal.ClientRelativeDateRange;
import com.jaspersoft.jasperserver.dto.adhoc.query.el.literal.ClientRelativeTimestampRange;
import com.jaspersoft.jasperserver.dto.adhoc.query.el.literal.ClientString;
import com.jaspersoft.jasperserver.dto.adhoc.query.el.literal.ClientTime;
import com.jaspersoft.jasperserver.dto.adhoc.query.el.literal.ClientTimestamp;
import com.jaspersoft.jasperserver.dto.adhoc.query.el.operator.ClientFunction;
import com.jaspersoft.jasperserver.dto.adhoc.query.el.operator.ClientOperation;
import com.jaspersoft.jasperserver.dto.adhoc.query.el.operator.arithmetic.ClientAdd;
import com.jaspersoft.jasperserver.dto.adhoc.query.el.operator.arithmetic.ClientDivide;
import com.jaspersoft.jasperserver.dto.adhoc.query.el.operator.arithmetic.ClientMultiply;
import com.jaspersoft.jasperserver.dto.adhoc.query.el.operator.arithmetic.ClientPercentRatio;
import com.jaspersoft.jasperserver.dto.adhoc.query.el.operator.arithmetic.ClientSubtract;
import com.jaspersoft.jasperserver.dto.adhoc.query.el.operator.comparison.ClientEquals;
import com.jaspersoft.jasperserver.dto.adhoc.query.el.operator.comparison.ClientGreater;
import com.jaspersoft.jasperserver.dto.adhoc.query.el.operator.comparison.ClientGreaterOrEqual;
import com.jaspersoft.jasperserver.dto.adhoc.query.el.operator.comparison.ClientLess;
import com.jaspersoft.jasperserver.dto.adhoc.query.el.operator.comparison.ClientLessOrEqual;
import com.jaspersoft.jasperserver.dto.adhoc.query.el.operator.comparison.ClientNotEqual;
import com.jaspersoft.jasperserver.dto.adhoc.query.el.operator.logical.ClientAnd;
import com.jaspersoft.jasperserver.dto.adhoc.query.el.operator.logical.ClientNot;
import com.jaspersoft.jasperserver.dto.adhoc.query.el.operator.logical.ClientOr;
import com.jaspersoft.jasperserver.dto.adhoc.query.el.operator.membership.ClientIn;
import com.jaspersoft.jasperserver.dto.adhoc.query.el.range.ClientRange;
import com.jaspersoft.jasperserver.dto.utils.ValueObjectUtils;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlTransient;

public abstract class ClientOperator<F extends ClientOperator<F>>
implements ClientExpression<F> {
    public static final String DOMEL_INCORRECT_OPERANDS_COUNT = "domel.incorrect.operands.count";
    private ClientOperation operator;
    @NotNull
    @Valid
    protected List<ClientExpression> operands = new ArrayList<ClientExpression>();
    protected Boolean paren;

    public ClientOperator() {
        this.operands = new ArrayList<ClientExpression>();
        this.operator = ClientOperation.UNDEFINED;
    }

    public ClientOperator(ClientOperation operator) {
        this.operator = operator;
    }

    public ClientOperator(ClientOperation operator, List<? extends ClientExpression> operands) {
        this(operator);
        this.operands = operands == null ? new ArrayList<ClientExpression>() : new ArrayList<ClientExpression>(operands);
    }

    public ClientOperator(ClientOperation operator, Boolean paren) {
        this();
        this.operator = operator;
        this.paren = paren;
    }

    protected ClientOperator(ClientOperation operator, List<? extends ClientExpression> operands, Boolean paren) {
        this(operator);
        this.operands = ValueObjectUtils.copyOf(new ArrayList<ClientExpression>(operands));
        this.paren = paren;
    }

    @XmlTransient
    public String getOperatorName() {
        return this.operator.getDomelOperator();
    }

    protected ClientOperator(ClientOperator source) {
        ValueObjectUtils.checkNotNull(source);
        this.operator = source.operator;
        this.paren = source.paren;
        this.operands = ValueObjectUtils.copyOf(source.operands);
    }

    @XmlTransient
    public ClientOperation getOperator() {
        return this.operator;
    }

    @XmlElementWrapper(name="operands")
    @XmlElements(value={@XmlElement(name="NULL", type=ClientNull.class), @XmlElement(name="boolean", type=ClientBoolean.class), @XmlElement(name="number", type=ClientNumber.class), @XmlElement(name="relativeDateRange", type=ClientRelativeDateRange.class), @XmlElement(name="relativeTimestampRange", type=ClientRelativeTimestampRange.class), @XmlElement(name="string", type=ClientString.class), @XmlElement(name="date", type=ClientDate.class), @XmlElement(name="time", type=ClientTime.class), @XmlElement(name="timestamp", type=ClientTimestamp.class), @XmlElement(name="variable", type=ClientVariable.class), @XmlElement(name="not", type=ClientNot.class), @XmlElement(name="and", type=ClientAnd.class), @XmlElement(name="or", type=ClientOr.class), @XmlElement(name="greater", type=ClientGreater.class), @XmlElement(name="greaterOrEqual", type=ClientGreaterOrEqual.class), @XmlElement(name="less", type=ClientLess.class), @XmlElement(name="lessOrEqual", type=ClientLessOrEqual.class), @XmlElement(name="notEqual", type=ClientNotEqual.class), @XmlElement(name="equals", type=ClientEquals.class), @XmlElement(name="function", type=ClientFunction.class), @XmlElement(name="in", type=ClientIn.class), @XmlElement(name="range", type=ClientRange.class), @XmlElement(name="add", type=ClientAdd.class), @XmlElement(name="subtract", type=ClientSubtract.class), @XmlElement(name="multiply", type=ClientMultiply.class), @XmlElement(name="divide", type=ClientDivide.class), @XmlElement(name="percentRatio", type=ClientPercentRatio.class), @XmlElement(name="list", type=ClientList.class)})
    public List<ClientExpression> getOperands() {
        return this.operands;
    }

    public F setOperands(List<ClientExpression> operands) {
        if (operands != null) {
            this.operands = new ArrayList<ClientExpression>();
            for (ClientExpression op : operands) {
                this.addOperand(op);
            }
        } else {
            this.operands = null;
        }
        return (F)this;
    }

    private ClientExpression setOperandParensIfNeeded(ClientExpression operand) {
        if (!(operand instanceof ClientOperator)) {
            return operand;
        }
        ClientOperator op = (ClientOperator)operand;
        if (op.isParen() != null && op.isParen().booleanValue()) {
            return op;
        }
        if (this.operandNeedsParens(op)) {
            op = (ClientOperator)op.deepClone();
            op.setParen();
        }
        return op;
    }

    protected boolean operandNeedsParens(ClientOperator operand) {
        return operand.getPrecedence() < this.getPrecedence();
    }

    public F addOperand(ClientExpression operand) {
        if (this.operands == null) {
            this.operands = new ArrayList<ClientExpression>();
        }
        this.operands.add(this.setOperandParensIfNeeded(operand));
        return (F)this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClientOperator that = (ClientOperator)o;
        if (this.operator != null ? !this.operator.equals((Object)that.operator) : that.operator != null) {
            return false;
        }
        if (this.operands != null ? !this.operands.equals(that.operands) : that.operands != null) {
            return false;
        }
        return this.paren != null ? this.paren.equals(that.paren) : that.paren == null;
    }

    public int hashCode() {
        int result = this.operator != null ? this.operator.hashCode() : 0;
        result = 31 * result + (this.operands != null ? this.operands.hashCode() : 0);
        result = 31 * result + (this.paren != null ? this.paren.hashCode() : 0);
        return result;
    }

    @Override
    public void accept(ClientELVisitor visitor) {
        visitor.visit(this);
        if (this.getOperands() != null) {
            for (ClientExpression expr : this.getOperands()) {
                if (expr == null) continue;
                expr.accept(visitor);
            }
        }
    }

    public boolean hasParen() {
        return this.paren != null && this.paren != false;
    }

    @XmlElement(name="paren")
    public Boolean isParen() {
        return this.paren;
    }

    public F setParen(Boolean paren) {
        if (paren != null && paren.booleanValue()) {
            this.paren = paren;
        } else {
            this.unsetParen();
        }
        return (F)this;
    }

    public F setParen() {
        this.paren = Boolean.TRUE;
        return (F)this;
    }

    public F unsetParen() {
        this.paren = null;
        return (F)this;
    }

    protected String addStringOperand(ClientExpression operand) {
        StringBuilder result = new StringBuilder();
        result.append(operand == null ? "$missing$" : operand.toString());
        return result.toString();
    }

    protected String operandsToString(List<ClientExpression> operands, String separator) {
        StringBuilder sb = new StringBuilder();
        for (ClientExpression operand : operands) {
            sb.append(this.addStringOperand(operand));
            sb.append(separator);
        }
        int indexOfLastSeparator = sb.lastIndexOf(separator);
        if (indexOfLastSeparator != -1) {
            sb.replace(indexOfLastSeparator, indexOfLastSeparator + separator.length(), "");
        }
        return sb.toString();
    }

    @XmlTransient
    public abstract int getPrecedence();
}

