/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.dto.adhoc.query.el.literal;

import com.jaspersoft.jasperserver.dto.adhoc.query.adapter.ELDateAdapter;
import com.jaspersoft.jasperserver.dto.adhoc.query.el.ClientLiteral;
import com.jaspersoft.jasperserver.dto.adhoc.query.el.adapters.DomELCommonSimpleDateFormats;
import com.jaspersoft.jasperserver.dto.adhoc.query.el.ast.ClientELVisitor;
import com.jaspersoft.jasperserver.dto.utils.ValueObjectUtils;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

@XmlRootElement(name="date")
public class ClientDate
extends ClientLiteral<Date, ClientDate> {
    public static final String EXPRESSION_ID = "date";
    public static final DateFormat FORMATTER = DomELCommonSimpleDateFormats.dateFormat();

    public ClientDate() {
    }

    public ClientDate(Date date) {
        super(date);
    }

    public ClientDate(ClientDate d) {
        ValueObjectUtils.checkNotNull(d);
        this.setValue(ValueObjectUtils.copyOf(d.getValue()));
    }

    @Override
    public ClientDate deepClone() {
        return new ClientDate(this);
    }

    @Override
    public ClientDate setValue(Date value) {
        this.value = value;
        return this;
    }

    @Override
    @XmlJavaTypeAdapter(value=ELDateAdapter.class)
    public Date getValue() {
        return (Date)this.value;
    }

    @Override
    public String toString() {
        String valueString;
        Date value = this.getValue();
        try {
            valueString = value != null ? FORMATTER.format(value) : "$missing$";
        }
        catch (IllegalArgumentException e) {
            valueString = "$missing$";
        }
        return "d'" + valueString + "'";
    }

    public static ClientDate valueOf(String string) {
        try {
            return new ClientDate(DomELCommonSimpleDateFormats.dateFormat().parse(string));
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Unable to parse given value for date: " + string);
        }
    }

    @Override
    public void accept(ClientELVisitor visitor) {
        visitor.visit(this);
    }
}

