/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.dto.adhoc.query.el.literal;

import com.jaspersoft.jasperserver.dto.adhoc.query.el.ClientLiteral;
import com.jaspersoft.jasperserver.dto.adhoc.query.el.literal.ClientBoolean;
import com.jaspersoft.jasperserver.dto.adhoc.query.el.literal.ClientDate;
import com.jaspersoft.jasperserver.dto.adhoc.query.el.literal.ClientNull;
import com.jaspersoft.jasperserver.dto.adhoc.query.el.literal.ClientNumber;
import com.jaspersoft.jasperserver.dto.adhoc.query.el.literal.ClientRelativeDateRange;
import com.jaspersoft.jasperserver.dto.adhoc.query.el.literal.ClientRelativeTimestampRange;
import com.jaspersoft.jasperserver.dto.adhoc.query.el.literal.ClientString;
import com.jaspersoft.jasperserver.dto.adhoc.query.el.literal.ClientTime;
import com.jaspersoft.jasperserver.dto.adhoc.query.el.literal.ClientTimestamp;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlValue;

public enum ClientLiteralType {
    BYTE(new ClientNumber()),
    SHORT(new ClientNumber()),
    INTEGER(new ClientNumber()),
    LONG(new ClientNumber()),
    BIG_INTEGER(new ClientNumber()),
    FLOAT(new ClientNumber()),
    DOUBLE(new ClientNumber()),
    BIG_DECIMAL(new ClientNumber()),
    DATE(new ClientDate()),
    RELATIVE_DATE_RANGE(new ClientRelativeDateRange()),
    RELATIVE_TIMESTAMP_RANGE(new ClientRelativeTimestampRange()),
    TIME(new ClientTime()),
    TIMESTAMP(new ClientTimestamp()),
    STRING(new ClientString()),
    BOOLEAN(new ClientBoolean()),
    NULL(new ClientNull());

    private String name;
    private final ClientLiteral literal;

    private ClientLiteralType(ClientLiteral literal) {
        this.literal = literal;
        XmlRootElement xmlRootElement = literal.getClass().getAnnotation(XmlRootElement.class);
        this.name = xmlRootElement.name();
    }

    @XmlValue
    public String getName() {
        return this.name;
    }

    public static ClientLiteralType fromString(String text) {
        for (ClientLiteralType t : ClientLiteralType.values()) {
            if (!t.getName().equalsIgnoreCase(text)) continue;
            return t;
        }
        throw new IllegalArgumentException("Invalid literal type: " + text);
    }

    public <T extends ClientLiteral> T getLiteralInstance() {
        return (T)this.literal.deepClone();
    }
}

