/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.dto.adhoc.query.el.literal;

import com.jaspersoft.jasperserver.dto.adhoc.query.adapter.ELTimeAdapter;
import com.jaspersoft.jasperserver.dto.adhoc.query.el.ClientLiteral;
import com.jaspersoft.jasperserver.dto.adhoc.query.el.adapters.DomELCommonSimpleDateFormats;
import com.jaspersoft.jasperserver.dto.adhoc.query.el.ast.ClientELVisitor;
import com.jaspersoft.jasperserver.dto.utils.ValueObjectUtils;
import java.sql.Time;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.regex.Pattern;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

@XmlRootElement(name="time")
public class ClientTime
extends ClientLiteral<Time, ClientTime> {
    public static final String EXPRESSION_ID = "time";
    public static final DateFormat FORMATTER = DomELCommonSimpleDateFormats.timeFormat();

    public ClientTime() {
    }

    public ClientTime(Time time) {
        super(time);
    }

    public ClientTime(ClientTime source) {
        ValueObjectUtils.checkNotNull(source);
        this.setValue(ValueObjectUtils.copyOf(source.getValue()));
    }

    @Override
    @XmlJavaTypeAdapter(value=ELTimeAdapter.class)
    public Time getValue() {
        return (Time)this.value;
    }

    @Override
    public ClientTime setValue(Time value) {
        this.value = value;
        return this;
    }

    public static ClientTime valueOf(String string) {
        try {
            return new ClientTime().setValue(new Time(DomELCommonSimpleDateFormats.timeFormat().parse(string).getTime()));
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Unable to parse given value for time: " + string);
        }
    }

    @Override
    public ClientTime deepClone() {
        return new ClientTime(this);
    }

    @Override
    public String toString() {
        String valueString;
        Time value = this.getValue();
        try {
            valueString = value != null ? FORMATTER.format(value) : "$missing$";
        }
        catch (IllegalArgumentException e) {
            valueString = "$missing$";
        }
        String zeroMilliseconds = "(\\.0+)$";
        if (valueString.contains(".") && Pattern.matches("[\\d\\s:]*" + zeroMilliseconds, valueString)) {
            valueString = valueString.substring(0, valueString.indexOf("."));
        }
        return "t'" + valueString + "'";
    }

    @Override
    public void accept(ClientELVisitor visitor) {
        visitor.visit(this);
    }
}

