/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.dto.adhoc.query.el.literal;

import com.jaspersoft.jasperserver.dto.adhoc.query.adapter.ELTimestampAdapter;
import com.jaspersoft.jasperserver.dto.adhoc.query.el.ClientLiteral;
import com.jaspersoft.jasperserver.dto.adhoc.query.el.ast.ClientELVisitor;
import com.jaspersoft.jasperserver.dto.utils.ValueObjectUtils;
import java.sql.Timestamp;
import java.util.regex.Pattern;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

@XmlRootElement(name="timestamp")
public class ClientTimestamp
extends ClientLiteral<Timestamp, ClientTimestamp> {
    public static final String EXPRESSION_ID = "timestamp";
    private static final ELTimestampAdapter TIMESTAMP_ADAPTER = new ELTimestampAdapter();

    public ClientTimestamp() {
    }

    public ClientTimestamp(Timestamp timestamp) {
        super(timestamp);
    }

    public ClientTimestamp(ClientTimestamp t) {
        ValueObjectUtils.checkNotNull(t);
        this.setValue(ValueObjectUtils.copyOf(t.getValue()));
    }

    @Override
    @XmlJavaTypeAdapter(value=ELTimestampAdapter.class)
    public Timestamp getValue() {
        return (Timestamp)this.value;
    }

    @Override
    public ClientTimestamp setValue(Timestamp value) {
        this.value = value;
        return this;
    }

    @Override
    public ClientTimestamp deepClone() {
        return new ClientTimestamp(this);
    }

    public static ClientTimestamp valueOf(String string) {
        Timestamp timestamp;
        try {
            timestamp = TIMESTAMP_ADAPTER.unmarshal(string);
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
        return new ClientTimestamp().setValue(timestamp);
    }

    @Override
    public String toString() {
        String formattedValue;
        Timestamp value = this.getValue();
        try {
            formattedValue = TIMESTAMP_ADAPTER.marshal(value);
        }
        catch (Exception e) {
            formattedValue = "$missing$";
        }
        String preciselyMidnightRegex = "(00:?){3}(\\.0+)?$";
        String resultFormat = Pattern.matches("[\\d-T\\s]*" + preciselyMidnightRegex, formattedValue) ? formattedValue.replaceFirst("[\\sT]" + preciselyMidnightRegex, "") : (formattedValue.contains(".") && Pattern.matches("[\\d-T\\s:]*(\\.0+)?$", formattedValue) ? formattedValue.substring(0, formattedValue.indexOf(".")) : formattedValue);
        return "ts'" + resultFormat + "'";
    }

    @Override
    public void accept(ClientELVisitor visitor) {
        visitor.visit(this);
    }
}

