/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.dto.adhoc.query.el.operator;

import com.jaspersoft.jasperserver.dto.adhoc.query.el.ClientExpression;
import com.jaspersoft.jasperserver.dto.adhoc.query.el.ClientOperator;
import com.jaspersoft.jasperserver.dto.adhoc.query.el.ast.ClientELVisitor;
import com.jaspersoft.jasperserver.dto.adhoc.query.el.operator.ClientOperation;
import com.jaspersoft.jasperserver.dto.adhoc.query.el.operator.comparison.ClientEquals;
import com.jaspersoft.jasperserver.dto.adhoc.query.el.operator.comparison.ClientGreater;
import com.jaspersoft.jasperserver.dto.adhoc.query.el.operator.comparison.ClientGreaterOrEqual;
import com.jaspersoft.jasperserver.dto.adhoc.query.el.operator.comparison.ClientLess;
import com.jaspersoft.jasperserver.dto.adhoc.query.el.operator.comparison.ClientLessOrEqual;
import com.jaspersoft.jasperserver.dto.adhoc.query.el.operator.comparison.ClientNotEqual;
import com.jaspersoft.jasperserver.dto.adhoc.query.validation.CheckExpressionOperandsSize;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlTransient;

public abstract class ClientComparison<F extends ClientComparison<F>>
extends ClientOperator<F> {
    public ClientComparison() {
        super(ClientOperation.UNDEFINED);
    }

    protected ClientComparison(ClientOperation operation) {
        super(operation);
    }

    protected ClientComparison(ClientOperation operation, List<? extends ClientExpression> operands) {
        super(operation, operands);
    }

    protected ClientComparison(ClientOperation operation, List<? extends ClientExpression> operands, Boolean paren) {
        super(operation, operands, paren);
        this.setParen(paren);
    }

    protected ClientComparison(ClientComparison source) {
        super(source);
    }

    public static ClientComparison eq(ClientExpression lhs, ClientExpression rhs) {
        return new ClientEquals().setOperands((List)Arrays.asList(lhs, rhs));
    }

    public static ClientGreaterOrEqual gtOrEq(ClientExpression lhs, ClientExpression rhs) {
        return (ClientGreaterOrEqual)new ClientGreaterOrEqual().setOperands((List)Arrays.asList(lhs, rhs));
    }

    public static ClientLessOrEqual ltOrEq(ClientExpression lhs, ClientExpression rhs) {
        return (ClientLessOrEqual)new ClientLessOrEqual().setOperands((List)Arrays.asList(lhs, rhs));
    }

    public static ClientGreater gt(ClientExpression lhs, ClientExpression rhs) {
        return (ClientGreater)new ClientGreater().setOperands((List)Arrays.asList(lhs, rhs));
    }

    public static ClientComparison lt(ClientExpression lhs, ClientExpression rhs) {
        return new ClientLess().setOperands((List)Arrays.asList(lhs, rhs));
    }

    public static ClientComparison notEq(ClientExpression lhs, ClientExpression rhs) {
        return new ClientNotEqual().setOperands((List)Arrays.asList(lhs, rhs));
    }

    public static ClientComparison createComparison(String name, List<ClientExpression> operands) {
        ClientOperation operation = ClientOperation.fromString(name);
        if (operation != null) {
            ClientComparison comparison = null;
            switch (operation) {
                case GREATER: {
                    comparison = new ClientGreater(operands);
                    break;
                }
                case GREATER_OR_EQUAL: {
                    comparison = new ClientGreaterOrEqual(operands);
                    break;
                }
                case LESS: {
                    comparison = new ClientLess(operands);
                    break;
                }
                case LESS_OR_EQUAL: {
                    comparison = new ClientLessOrEqual(operands);
                    break;
                }
                case EQUALS: {
                    comparison = new ClientEquals(operands);
                    break;
                }
                case NOT_EQUAL: {
                    comparison = new ClientNotEqual(operands);
                }
            }
            return comparison;
        }
        return null;
    }

    @Override
    @CheckExpressionOperandsSize(min=2, max=2)
    public List<ClientExpression> getOperands() {
        return super.getOperands();
    }

    @Override
    public F setOperands(List<ClientExpression> operands) {
        super.setOperands(operands);
        return (F)this;
    }

    @XmlTransient
    public ClientExpression getLhs() {
        return this.operands.size() > 0 ? (ClientExpression)this.operands.get(0) : null;
    }

    @XmlTransient
    public ClientExpression getRhs() {
        return this.operands.size() > 1 ? (ClientExpression)this.operands.get(1) : null;
    }

    @Override
    public void accept(ClientELVisitor visitor) {
        List<ClientExpression> operands = this.getOperands();
        if (operands != null && !operands.isEmpty()) {
            operands.get(0).accept(visitor);
        }
        if (operands != null && operands.size() > 1) {
            operands.get(1).accept(visitor);
        }
    }

    public String toString() {
        String rhsString;
        StringBuilder sb = new StringBuilder();
        List<ClientExpression> operands = this.getOperands();
        String lhsString = operands != null && !operands.isEmpty() ? operands.get(0).toString() : "$missing$";
        String string = rhsString = operands != null && operands.size() > 1 ? operands.get(1).toString() : "$missing$";
        if (this.hasParen()) {
            sb.append("(");
        }
        sb.append(lhsString).append(" ").append(this.getOperator().getDomelOperator()).append(" ").append(rhsString);
        if (this.hasParen()) {
            sb.append(")");
        }
        return sb.toString();
    }

    @Override
    public int getPrecedence() {
        return 3;
    }
}

