/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.dto.adhoc.query.el.operator;

import com.jaspersoft.jasperserver.dto.adhoc.query.el.ClientExpression;
import com.jaspersoft.jasperserver.dto.adhoc.query.el.ClientOperator;
import com.jaspersoft.jasperserver.dto.adhoc.query.el.ast.ClientELVisitor;
import com.jaspersoft.jasperserver.dto.adhoc.query.el.operator.ClientOperation;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="function")
public class ClientFunction
extends ClientOperator<ClientFunction> {
    public static final String EXPRESSION_ID = "function";
    protected String functionName;

    public ClientFunction() {
        super(ClientOperation.FUNCTION, new ArrayList());
    }

    public ClientFunction(String functionName, List<ClientExpression> operands) {
        super(ClientOperation.FUNCTION, operands);
        this.functionName = functionName;
    }

    public ClientFunction(ClientFunction source) {
        super(source);
        this.functionName = source.getFunctionName();
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public ClientFunction(String functionName) {
        this();
        this.functionName = functionName;
    }

    public ClientFunction setFunctionName(String functionName) {
        this.functionName = functionName;
        return this;
    }

    public ClientFunction addArgument(ClientExpression expr) {
        this.operands.add(expr);
        return this;
    }

    public String toString() {
        String functionNameString = this.functionName != null ? this.functionName : "$missing$";
        return functionNameString + "(" + this.operandsToString(this.getOperands(), ", ") + ")";
    }

    @Override
    protected String addStringOperand(ClientExpression operand) {
        return operand.toString();
    }

    @Override
    public void accept(ClientELVisitor visitor) {
        super.accept(visitor);
        visitor.visit(this);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ClientFunction)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ClientFunction that = (ClientFunction)o;
        return this.functionName != null ? this.functionName.equals(that.functionName) : that.functionName == null;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.functionName != null ? this.functionName.hashCode() : 0);
        return result;
    }

    @Override
    public ClientFunction deepClone() {
        return new ClientFunction(this);
    }

    @Override
    public int getPrecedence() {
        return 6;
    }

    @Override
    protected boolean operandNeedsParens(ClientOperator operand) {
        return false;
    }
}

