/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.dto.adhoc.query.el.operator;

import com.jaspersoft.jasperserver.dto.adhoc.query.el.ClientExpression;
import com.jaspersoft.jasperserver.dto.adhoc.query.el.ClientOperator;
import com.jaspersoft.jasperserver.dto.adhoc.query.el.ast.ClientELVisitor;
import com.jaspersoft.jasperserver.dto.adhoc.query.el.operator.ClientOperation;
import com.jaspersoft.jasperserver.dto.adhoc.query.el.operator.logical.ClientAnd;
import com.jaspersoft.jasperserver.dto.adhoc.query.el.operator.logical.ClientOr;
import java.util.Arrays;
import java.util.List;

public abstract class ClientLogical<F extends ClientLogical<F>>
extends ClientOperator<F> {
    public ClientLogical() {
    }

    public ClientLogical(ClientOperation type) {
        super(type);
    }

    public ClientLogical(ClientLogical source) {
        super(source);
    }

    public ClientLogical(ClientOperation operation, List<? extends ClientExpression> operands) {
        super(operation, operands);
    }

    protected ClientLogical(ClientOperation operation, List<ClientExpression> operands, Boolean paren) {
        super(operation, operands, paren);
    }

    public static <T extends ClientLogical> T createLogical(ClientOperation operator, List<ClientExpression> operands) {
        return ClientLogical.createLogical(operator.getName(), operands);
    }

    public static <T extends ClientLogical> T createLogical(String name, List<ClientExpression> operands) {
        ClientOperation operation = ClientOperation.fromString(name);
        if (operation != null) {
            if (operation.equals((Object)ClientOperation.AND)) {
                return (T)new ClientAnd().setOperands((List)operands);
            }
            if (operation.equals((Object)ClientOperation.OR)) {
                return (T)new ClientOr().setOperands((List)operands);
            }
            return null;
        }
        return null;
    }

    public static <T extends ClientLogical> T createLogical(String name, List<ClientExpression> operands, boolean isParen) {
        T result = ClientLogical.createLogical(name, operands);
        if (isParen && result != null) {
            ((ClientOperator)result).setParen(true);
        }
        return result;
    }

    public static ClientAnd and(ClientExpression lhs, ClientExpression rhs) {
        ClientLogical.checkArguments(lhs, rhs);
        return (ClientAnd)new ClientAnd().setOperands((List)Arrays.asList(lhs, rhs));
    }

    public static ClientOr or(ClientExpression lhs, ClientExpression rhs) {
        ClientLogical.checkArguments(lhs, rhs);
        return (ClientOr)new ClientOr().setOperands((List)Arrays.asList(lhs, rhs));
    }

    static void checkArguments(ClientExpression ... expressions) throws IllegalArgumentException {
        if (expressions.length < 2) {
            throw new IllegalArgumentException("Error creating 'and/or' logical expression. Expression is not defined!");
        }
    }

    public ClientOr or(ClientExpression expression) {
        return ClientLogical.or(this, expression);
    }

    public ClientAnd and(ClientExpression expression) {
        return ClientLogical.and(this, expression);
    }

    @Override
    public F setOperands(List<ClientExpression> operands) {
        if (operands != null && operands.size() > 2) {
            throw new UnsupportedOperationException("Failed to create ClientLogical with more than 2 operands");
        }
        super.setOperands(operands);
        return (F)this;
    }

    public String toString() {
        String rhsString;
        StringBuilder sb = new StringBuilder();
        boolean hasOperands = !this.operands.isEmpty();
        String lhsString = hasOperands && this.operands.get(0) != null ? ((ClientExpression)this.operands.get(0)).toString() : "$missing$";
        String string = rhsString = hasOperands && this.operands.size() > 1 && this.operands.get(1) != null ? ((ClientExpression)this.operands.get(1)).toString() : "$missing$";
        if (this.hasParen()) {
            sb.append("(");
        }
        sb.append(lhsString).append(" ").append(this.getOperator().getDomelOperator()).append(" ").append(rhsString);
        if (this.hasParen()) {
            sb.append(")");
        }
        return sb.toString();
    }

    @Override
    public void accept(ClientELVisitor visitor) {
        if (this.operands != null && !this.operands.isEmpty()) {
            if (this.operands.get(0) != null) {
                ((ClientExpression)this.operands.get(0)).accept(visitor);
            }
            if (this.operands.size() > 1 && this.operands.get(1) != null) {
                ((ClientExpression)this.operands.get(1)).accept(visitor);
            }
        }
    }
}

