/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.dto.adhoc.query.el.operator;

public enum ClientOperation {
    EQUALS("equals", "==", 2),
    NOT_EQUAL("notEqual", "!=", 2),
    GREATER_OR_EQUAL("greaterOrEqual", ">=", 2),
    LESS_OR_EQUAL("lessOrEqual", "<=", 2),
    GREATER("greater", ">", 2),
    LESS("less", "<", 2),
    IN("in", "in", 2),
    NOT("not", "not", 3),
    AND("and", "and", 1),
    OR("or", "or", 0),
    ADD("add", "+", 4),
    SUBTRACT("subtract", "-", 4),
    DIVIDE("divide", "/", 5),
    MULTIPLY("multiply", "*", 5),
    FUNCTION("function", "", 6),
    PERCENT_FIELD_RATIO("percentRatio", "%", 5),
    UNDEFINED("undefined", "$missing$", 6);

    private final String name;
    private final String domelOperator;
    private final int priority;

    private ClientOperation(String name, String domelOperator, int priority) {
        this.name = name;
        this.domelOperator = domelOperator;
        this.priority = priority;
    }

    public String getName() {
        return this.name;
    }

    public int getPriority() {
        return this.priority;
    }

    public String getDomelOperator() {
        return this.domelOperator;
    }

    public static ClientOperation fromString(String text) {
        for (ClientOperation o : ClientOperation.values()) {
            if (!o.getName().equals(text)) continue;
            return o;
        }
        return null;
    }

    public static ClientOperation fromDomElOperator(String operator) {
        for (ClientOperation o : ClientOperation.values()) {
            if (!o.getName().equals(operator)) continue;
            return o;
        }
        return null;
    }

    public static boolean isSupported(String text) {
        ClientOperation co = ClientOperation.fromString(text);
        return co != null;
    }
}

