/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.dto.adhoc.query.el.operator.membership;

import com.jaspersoft.jasperserver.dto.adhoc.query.el.ClientExpression;
import com.jaspersoft.jasperserver.dto.adhoc.query.el.ClientList;
import com.jaspersoft.jasperserver.dto.adhoc.query.el.ClientOperator;
import com.jaspersoft.jasperserver.dto.adhoc.query.el.ClientVariable;
import com.jaspersoft.jasperserver.dto.adhoc.query.el.ast.ClientELVisitor;
import com.jaspersoft.jasperserver.dto.adhoc.query.el.operator.ClientOperation;
import com.jaspersoft.jasperserver.dto.adhoc.query.el.range.ClientRange;
import com.jaspersoft.jasperserver.dto.adhoc.query.validation.InstanceOf;
import java.util.ArrayList;
import java.util.List;
import javax.validation.constraints.Size;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;

@XmlRootElement(name="in")
public class ClientIn
extends ClientOperator<ClientIn> {
    public static final String EXPRESSION_ID = "in";

    public ClientIn() {
        super(ClientOperation.IN);
    }

    public ClientIn(ClientVariable variable, List<ClientExpression> list) {
        this((ClientExpression)variable, (ClientExpression)new ClientList(list));
    }

    public ClientIn(ClientVariable variable, ClientRange range) {
        this((ClientExpression)variable, (ClientExpression)range);
    }

    public ClientIn(ClientVariable variable, ClientList list) {
        this((ClientExpression)variable, (ClientExpression)list);
    }

    public ClientIn(ClientVariable variable, ClientVariable inVariable) {
        this((ClientExpression)variable, (ClientExpression)inVariable);
    }

    public ClientIn(ClientExpression lhs, ClientExpression rhs) {
        this();
        this.operands = new ArrayList(2);
        this.operands.add(lhs);
        this.operands.add(rhs);
        super.setOperands(this.operands);
    }

    public ClientIn(ClientIn source) {
        super(source);
    }

    @XmlTransient
    public ClientExpression getLhs() {
        return this.operands != null && !this.operands.isEmpty() ? (ClientExpression)this.operands.get(0) : null;
    }

    @InstanceOf(value={ClientRange.class, ClientList.class, ClientVariable.class}, message="The second operand of an In expression may only be a 'list', 'range' or 'variable'", errorCode="domel.in.rhs.type.invalid")
    @XmlTransient
    public ClientExpression getRhs() {
        if (this.operands != null && this.operands.size() > 1) {
            return (ClientExpression)this.operands.get(1);
        }
        return null;
    }

    @Override
    @Size(min=2, max=2, message="domel.incorrect.operands.count")
    public List<ClientExpression> getOperands() {
        return this.operands;
    }

    public String toString() {
        String rhs;
        boolean hasOperands = this.operands != null && !this.operands.isEmpty();
        String lhs = hasOperands && this.operands.get(0) != null ? ((ClientExpression)this.operands.get(0)).toString() : "$missing$";
        String string = rhs = hasOperands && this.operands.size() > 1 && this.operands.get(1) != null ? ((ClientExpression)this.operands.get(1)).toString() : "$missing$";
        if (this.hasParen()) {
            return "(" + lhs + " " + this.getOperator().getDomelOperator() + " " + rhs + ")";
        }
        return lhs + " " + this.getOperator().getDomelOperator() + " " + rhs;
    }

    @Override
    public void accept(ClientELVisitor visitor) {
        if (this.getLhs() != null) {
            this.getLhs().accept(visitor);
        }
        if (this.getRhs() != null) {
            this.getRhs().accept(visitor);
        }
        visitor.visit(this);
    }

    @Override
    public ClientIn deepClone() {
        return new ClientIn(this);
    }

    @Override
    public int getPrecedence() {
        return 3;
    }
}

