/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.dto.adhoc.query.el.range;

import com.jaspersoft.jasperserver.dto.adhoc.query.el.ClientExpression;
import com.jaspersoft.jasperserver.dto.adhoc.query.el.ClientLiteral;
import com.jaspersoft.jasperserver.dto.adhoc.query.el.ast.ClientELVisitor;
import com.jaspersoft.jasperserver.dto.adhoc.query.el.range.ClientRangeBoundary;
import com.jaspersoft.jasperserver.dto.utils.ValueObjectUtils;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlRootElement(name="range")
@XmlType(propOrder={"start", "end"})
public class ClientRange
implements ClientExpression<ClientRange> {
    public static final String EXPRESSION_ID = "range";
    private ClientRangeBoundary start;
    private ClientRangeBoundary end;

    public ClientRange() {
    }

    public ClientRange(ClientRangeBoundary start, ClientRangeBoundary end) {
        this.start = new ClientRangeBoundary(start);
        this.end = new ClientRangeBoundary(end);
    }

    public ClientRange(ClientLiteral start, ClientLiteral end) {
        this(new ClientRangeBoundary(start), new ClientRangeBoundary(end));
    }

    public ClientRange(ClientExpression start, ClientExpression end) {
        this(new ClientRangeBoundary(start), new ClientRangeBoundary(end));
    }

    public ClientRange(ClientRange range) {
        ValueObjectUtils.checkNotNull(range);
        this.start = ValueObjectUtils.copyOf(range.getStart());
        this.end = ValueObjectUtils.copyOf(range.getEnd());
    }

    public ClientRangeBoundary getEnd() {
        return this.end;
    }

    public ClientRange setEnd(ClientRangeBoundary end) {
        this.end = end;
        return this;
    }

    public ClientRangeBoundary getStart() {
        return this.start;
    }

    public ClientRange setStart(ClientRangeBoundary start) {
        this.start = start;
        return this;
    }

    @Override
    public void accept(ClientELVisitor visitor) {
        if (this.start != null && this.start.getBoundary() != null) {
            this.start.getBoundary().accept(visitor);
        }
        if (this.end != null && this.end.getBoundary() != null) {
            this.end.getBoundary().accept(visitor);
        }
        visitor.visit(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClientRange that = (ClientRange)o;
        if (this.start != null ? !this.start.equals(that.start) : that.start != null) {
            return false;
        }
        return this.end != null ? this.end.equals(that.end) : that.end == null;
    }

    public int hashCode() {
        int result = this.start != null ? this.start.hashCode() : 0;
        result = 31 * result + (this.end != null ? this.end.hashCode() : 0);
        return result;
    }

    public String toString() {
        String startString = this.getStart() != null && this.getStart().getBoundary() != null ? this.getStart().getBoundary().toString() : "$missing$";
        String endString = this.getEnd() != null && this.getEnd().getBoundary() != null ? this.getEnd().getBoundary().toString() : "$missing$";
        return "(" + startString + ":" + endString + ")";
    }

    @Override
    public ClientRange deepClone() {
        return new ClientRange(this);
    }
}

