/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.dto.adhoc.query.expansion;

import com.jaspersoft.jasperserver.dto.adhoc.query.ClientFieldReference;
import com.jaspersoft.jasperserver.dto.adhoc.query.expansion.ClientExpandable;
import com.jaspersoft.jasperserver.dto.utils.ValueObjectUtils;
import java.io.Serializable;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;

public class ClientLevelExpansion
implements ClientExpandable<String>,
ClientFieldReference,
Serializable {
    private boolean isExpanded;
    private Boolean isAggregationLevel = false;
    private String levelReference;

    public ClientLevelExpansion() {
    }

    public ClientLevelExpansion(ClientLevelExpansion expansion) {
        ValueObjectUtils.checkNotNull(expansion);
        this.isExpanded = expansion.isExpanded();
        this.isAggregationLevel = expansion.isAggregationLevel();
        this.levelReference = expansion.getLevelReference();
    }

    @Override
    public ClientLevelExpansion deepClone() {
        return new ClientLevelExpansion(this);
    }

    @Override
    public boolean isExpanded() {
        return this.isExpanded;
    }

    public ClientLevelExpansion setExpanded(boolean expanded) {
        this.isExpanded = expanded;
        return this;
    }

    @Override
    public String get() {
        return this.levelReference;
    }

    @XmlElement(name="fieldRef")
    public String getLevelReference() {
        return this.levelReference;
    }

    public ClientLevelExpansion setLevelReference(String levelReference) {
        this.levelReference = levelReference;
        return this;
    }

    @Override
    @XmlTransient
    public String getFieldReference() {
        return this.getLevelReference();
    }

    @XmlElement(name="aggregation")
    public Boolean isAggregationLevel() {
        return this.isAggregationLevel;
    }

    public ClientLevelExpansion setAggregationLevel(Boolean aggregationLevel) {
        this.isAggregationLevel = aggregationLevel != null ? aggregationLevel : false;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ClientLevelExpansion)) {
            return false;
        }
        ClientLevelExpansion that = (ClientLevelExpansion)o;
        if (this.isExpanded() != that.isExpanded()) {
            return false;
        }
        if (!this.isAggregationLevel.equals(that.isAggregationLevel)) {
            return false;
        }
        return this.getLevelReference() != null ? this.getLevelReference().equals(that.getLevelReference()) : that.getLevelReference() == null;
    }

    public int hashCode() {
        int result = this.isExpanded() ? 1 : 0;
        result = 31 * result + this.isAggregationLevel.hashCode();
        result = 31 * result + (this.getLevelReference() != null ? this.getLevelReference().hashCode() : 0);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ClientLevelExpansion{");
        sb.append("isAggregationLevel=").append(this.isAggregationLevel);
        sb.append(", isExpanded=").append(this.isExpanded);
        sb.append(", levelReference='").append(this.levelReference).append('\'');
        sb.append('}');
        return sb.toString();
    }
}

