/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.dto.adhoc.query.expansion;

import com.jaspersoft.jasperserver.dto.adhoc.query.expansion.ClientExpandable;
import com.jaspersoft.jasperserver.dto.utils.ValueObjectUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.validation.constraints.NotNull;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;

public class ClientMemberExpansion
implements ClientExpandable<List<String>>,
Serializable {
    public static final String PATH_SEPARATOR = "/";
    private boolean isExpanded;
    @NotNull
    private List<String> path = new ArrayList<String>();

    public ClientMemberExpansion() {
    }

    public ClientMemberExpansion(ClientMemberExpansion expansion) {
        ValueObjectUtils.checkNotNull(expansion);
        this.isExpanded = expansion.isExpanded();
        this.path = ValueObjectUtils.copyOf(expansion.getPath());
    }

    @Override
    public ClientMemberExpansion deepClone() {
        return new ClientMemberExpansion(this);
    }

    @Override
    public boolean isExpanded() {
        return this.isExpanded;
    }

    public ClientMemberExpansion setExpanded(boolean expanded) {
        this.isExpanded = expanded;
        return this;
    }

    @XmlElementWrapper(name="path")
    @XmlElement(name="item")
    public List<String> getPath() {
        return this.path;
    }

    public ClientMemberExpansion setPath(List<String> path) {
        this.path = new ArrayList<String>();
        if (path != null) {
            this.path.addAll(path);
        }
        return this;
    }

    @Override
    public List<String> get() {
        return this.getPath();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ClientMemberExpansion)) {
            return false;
        }
        ClientMemberExpansion expansion = (ClientMemberExpansion)o;
        if (this.isExpanded != expansion.isExpanded) {
            return false;
        }
        return this.path.equals(expansion.path);
    }

    public int hashCode() {
        int result = this.isExpanded ? 1 : 0;
        result = 31 * result + this.path.hashCode();
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ClientMemberExpansion{");
        sb.append("isExpanded=").append(this.isExpanded);
        sb.append(", path=").append(this.path);
        sb.append('}');
        return sb.toString();
    }
}

