/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.dto.adhoc.query.field;

import com.jaspersoft.jasperserver.dto.adhoc.datasource.ClientDataSourceField;
import com.jaspersoft.jasperserver.dto.adhoc.query.ClientAggregate;
import com.jaspersoft.jasperserver.dto.adhoc.query.ClientField;
import com.jaspersoft.jasperserver.dto.adhoc.query.ClientFieldReference;
import com.jaspersoft.jasperserver.dto.adhoc.query.ClientIdentifiable;
import com.jaspersoft.jasperserver.dto.adhoc.query.IExpressionContainer;
import com.jaspersoft.jasperserver.dto.adhoc.query.QueryPatternsUtil;
import com.jaspersoft.jasperserver.dto.adhoc.query.ast.ClientQueryExpression;
import com.jaspersoft.jasperserver.dto.adhoc.query.ast.ClientQueryVisitor;
import com.jaspersoft.jasperserver.dto.adhoc.query.el.ClientExpressionContainer;
import com.jaspersoft.jasperserver.dto.adhoc.query.el.ClientVariable;
import com.jaspersoft.jasperserver.dto.adhoc.query.el.literal.ClientBoolean;
import com.jaspersoft.jasperserver.dto.adhoc.query.el.literal.ClientDate;
import com.jaspersoft.jasperserver.dto.adhoc.query.el.literal.ClientNull;
import com.jaspersoft.jasperserver.dto.adhoc.query.el.literal.ClientNumber;
import com.jaspersoft.jasperserver.dto.adhoc.query.el.literal.ClientString;
import com.jaspersoft.jasperserver.dto.adhoc.query.el.literal.ClientTime;
import com.jaspersoft.jasperserver.dto.adhoc.query.el.literal.ClientTimestamp;
import com.jaspersoft.jasperserver.dto.adhoc.query.el.operator.ClientFunction;
import com.jaspersoft.jasperserver.dto.adhoc.query.el.operator.arithmetic.ClientAdd;
import com.jaspersoft.jasperserver.dto.adhoc.query.el.operator.arithmetic.ClientDivide;
import com.jaspersoft.jasperserver.dto.adhoc.query.el.operator.arithmetic.ClientMultiply;
import com.jaspersoft.jasperserver.dto.adhoc.query.el.operator.arithmetic.ClientSubtract;
import com.jaspersoft.jasperserver.dto.adhoc.query.el.operator.comparison.ClientEquals;
import com.jaspersoft.jasperserver.dto.adhoc.query.el.operator.comparison.ClientGreater;
import com.jaspersoft.jasperserver.dto.adhoc.query.el.operator.comparison.ClientGreaterOrEqual;
import com.jaspersoft.jasperserver.dto.adhoc.query.el.operator.comparison.ClientLess;
import com.jaspersoft.jasperserver.dto.adhoc.query.el.operator.comparison.ClientLessOrEqual;
import com.jaspersoft.jasperserver.dto.adhoc.query.el.operator.comparison.ClientNotEqual;
import com.jaspersoft.jasperserver.dto.adhoc.query.el.operator.logical.ClientAnd;
import com.jaspersoft.jasperserver.dto.adhoc.query.el.operator.logical.ClientNot;
import com.jaspersoft.jasperserver.dto.adhoc.query.el.operator.logical.ClientOr;
import com.jaspersoft.jasperserver.dto.adhoc.query.el.operator.membership.ClientIn;
import com.jaspersoft.jasperserver.dto.adhoc.query.el.range.ClientRange;
import com.jaspersoft.jasperserver.dto.adhoc.query.validation.CheckAggregateDefinition;
import com.jaspersoft.jasperserver.dto.adhoc.query.validation.CheckExpressionType;
import com.jaspersoft.jasperserver.dto.adhoc.query.validation.NotEmpty;
import com.jaspersoft.jasperserver.dto.common.DeepCloneable;
import com.jaspersoft.jasperserver.dto.utils.ValueObjectUtils;
import java.io.Serializable;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;

@XmlRootElement
@CheckAggregateDefinition
public class ClientQueryAggregatedField
implements ClientField,
ClientAggregate,
ClientFieldReference,
ClientIdentifiable<String>,
ClientQueryExpression,
IExpressionContainer,
DeepCloneable<ClientQueryAggregatedField>,
Serializable {
    private String id;
    private String aggregateFunction;
    private String fieldExpression;
    private String aggregateFirstLevelFunction;
    @CheckExpressionType(message="query.aggregation.expression.not.valid", value={ClientAdd.class, ClientAnd.class, ClientBoolean.class, ClientDate.class, ClientNumber.class, ClientDivide.class, ClientEquals.class, ClientFunction.class, ClientGreater.class, ClientGreaterOrEqual.class, ClientIn.class, ClientLess.class, ClientLessOrEqual.class, ClientMultiply.class, ClientNot.class, ClientNotEqual.class, ClientNull.class, ClientOr.class, ClientRange.class, ClientString.class, ClientSubtract.class, ClientTime.class, ClientTimestamp.class, ClientVariable.class})
    private ClientExpressionContainer expressionContainer;
    private String aggregateType;
    private String aggregateArg;
    @NotEmpty
    private String fieldRef;

    public ClientQueryAggregatedField() {
    }

    public ClientQueryAggregatedField(String field) {
        QueryPatternsUtil.NameAliasExpression nameAliasExpression = QueryPatternsUtil.parseNameAliasExpression(field);
        this.fieldRef = nameAliasExpression.name;
        this.id = nameAliasExpression.alias;
        if (nameAliasExpression.expression != null) {
            this.expressionContainer = new ClientExpressionContainer(nameAliasExpression.expression);
        }
    }

    public ClientQueryAggregatedField(ClientQueryAggregatedField field) {
        ValueObjectUtils.checkNotNull(field);
        this.id = field.getId();
        this.aggregateFunction = field.getAggregateFunction();
        this.aggregateFirstLevelFunction = field.getAggregateFirstLevelFunction();
        this.expressionContainer = ValueObjectUtils.copyOf(field.getExpressionContainer());
        this.aggregateType = field.getAggregateType();
        this.aggregateArg = field.getAggregateArg();
        this.fieldRef = field.getFieldReference();
    }

    @Override
    public String getId() {
        return this.id;
    }

    public ClientQueryAggregatedField setId(String id) {
        this.id = id;
        return this;
    }

    @Override
    @XmlTransient
    public String getName() {
        return this.fieldRef;
    }

    @Override
    @XmlElement(name="type")
    public String getType() {
        return this.getAggregateType();
    }

    public ClientQueryAggregatedField setType(String type) {
        this.setAggregateType(type);
        return this;
    }

    @Override
    @XmlElement(name="fieldRef")
    public String getFieldReference() {
        return this.fieldRef;
    }

    public ClientQueryAggregatedField setFieldReference(String fieldRef) {
        this.fieldRef = fieldRef;
        return this;
    }

    @Override
    @XmlElement(name="functionName")
    public String getAggregateFunction() {
        return this.aggregateFunction;
    }

    public ClientQueryAggregatedField setAggregateFunction(String aggregateFunction) {
        this.aggregateFunction = aggregateFunction;
        return this;
    }

    @Override
    @XmlElement(name="timeBalanceFunctionName")
    public String getAggregateFirstLevelFunction() {
        return this.aggregateFirstLevelFunction;
    }

    public ClientQueryAggregatedField setAggregateFirstLevelFunction(String aggregateFirstLevelFunction) {
        this.aggregateFirstLevelFunction = aggregateFirstLevelFunction;
        return this;
    }

    @Override
    @XmlTransient
    public String getAggregateExpression() {
        if (this.expressionContainer == null) {
            return null;
        }
        return this.expressionContainer.getString();
    }

    @Override
    public String getFieldExpression() {
        return this.fieldExpression;
    }

    @Override
    @XmlElement(name="expression")
    public ClientExpressionContainer getExpressionContainer() {
        return this.expressionContainer;
    }

    @Override
    public ClientQueryAggregatedField setExpressionContainer(ClientExpressionContainer expressionContainer) {
        this.expressionContainer = expressionContainer;
        return this;
    }

    @Override
    @Deprecated
    @XmlElement(name="arg")
    public String getAggregateArg() {
        return this.aggregateArg;
    }

    @Deprecated
    public ClientQueryAggregatedField setAggregateArg(String aggregateArg) {
        this.aggregateArg = aggregateArg;
        return this;
    }

    @Override
    @XmlTransient
    public String getAggregateType() {
        return this.aggregateType;
    }

    public ClientQueryAggregatedField setAggregateType(String aggregateType) {
        this.aggregateType = aggregateType;
        return this;
    }

    public ClientQueryAggregatedField setDataSourceField(ClientDataSourceField field) {
        this.setFieldReference(field.getName());
        return this;
    }

    @Deprecated
    public String getSecondAggregateField() {
        return this.getAggregateArg();
    }

    public void accept(ClientQueryVisitor visitor) {
        if (this.expressionContainer != null) {
            this.expressionContainer.getObject().accept(visitor);
        }
        visitor.visit(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClientQueryAggregatedField that = (ClientQueryAggregatedField)o;
        if (this.id != null ? !this.id.equals(that.id) : that.id != null) {
            return false;
        }
        if (this.aggregateFunction != null ? !this.aggregateFunction.equals(that.aggregateFunction) : that.aggregateFunction != null) {
            return false;
        }
        if (this.aggregateFirstLevelFunction != null ? !this.aggregateFirstLevelFunction.equals(that.aggregateFirstLevelFunction) : that.aggregateFirstLevelFunction != null) {
            return false;
        }
        if (this.expressionContainer != null ? !this.expressionContainer.equals(that.expressionContainer) : that.expressionContainer != null) {
            return false;
        }
        if (this.aggregateType != null ? !this.aggregateType.equals(that.aggregateType) : that.aggregateType != null) {
            return false;
        }
        if (this.aggregateArg != null ? !this.aggregateArg.equals(that.aggregateArg) : that.aggregateArg != null) {
            return false;
        }
        return !(this.fieldRef == null ? that.fieldRef != null : !this.fieldRef.equals(that.fieldRef));
    }

    public int hashCode() {
        int result = this.id != null ? this.id.hashCode() : 0;
        result = 31 * result + (this.aggregateFunction != null ? this.aggregateFunction.hashCode() : 0);
        result = 31 * result + (this.aggregateFirstLevelFunction != null ? this.aggregateFirstLevelFunction.hashCode() : 0);
        result = 31 * result + (this.expressionContainer != null ? this.expressionContainer.hashCode() : 0);
        result = 31 * result + (this.aggregateType != null ? this.aggregateType.hashCode() : 0);
        result = 31 * result + (this.aggregateArg != null ? this.aggregateArg.hashCode() : 0);
        result = 31 * result + (this.fieldRef != null ? this.fieldRef.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "ClientQueryAggregatedField{id='" + this.id + '\'' + ", aggregateFunction='" + this.aggregateFunction + '\'' + ", aggregateFirstLevelFunction='" + this.aggregateFirstLevelFunction + '\'' + ", expression=" + this.expressionContainer + ", aggregateType='" + this.aggregateType + '\'' + ", aggregateArg='" + this.aggregateArg + '\'' + ", name='" + this.getName() + '\'' + '}';
    }

    @Override
    public ClientQueryAggregatedField deepClone() {
        return new ClientQueryAggregatedField(this);
    }
}

