/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.dto.adhoc.query.field;

import com.jaspersoft.jasperserver.dto.adhoc.datasource.ClientDataSourceField;
import com.jaspersoft.jasperserver.dto.adhoc.query.ClientField;
import com.jaspersoft.jasperserver.dto.adhoc.query.ClientIdentifiable;
import com.jaspersoft.jasperserver.dto.adhoc.query.IExpressionContainer;
import com.jaspersoft.jasperserver.dto.adhoc.query.QueryPatternsUtil;
import com.jaspersoft.jasperserver.dto.adhoc.query.ast.ClientQueryExpression;
import com.jaspersoft.jasperserver.dto.adhoc.query.ast.ClientQueryVisitor;
import com.jaspersoft.jasperserver.dto.adhoc.query.el.ClientExpressionContainer;
import com.jaspersoft.jasperserver.dto.adhoc.query.validation.NotEmpty;
import com.jaspersoft.jasperserver.dto.common.DeepCloneable;
import com.jaspersoft.jasperserver.dto.utils.ValueObjectUtils;
import java.io.Serializable;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;

public class ClientQueryField
implements ClientField,
ClientIdentifiable<String>,
ClientQueryExpression,
IExpressionContainer,
DeepCloneable<ClientQueryField>,
Serializable {
    private String id;
    private String type;
    private boolean measure;
    @NotEmpty
    private String field;
    private ClientExpressionContainer expressionContainer;

    public ClientQueryField() {
    }

    public ClientQueryField(String field) {
        QueryPatternsUtil.NameAliasExpression nameAliasExpression = QueryPatternsUtil.parseNameAliasExpression(field);
        this.field = nameAliasExpression.name;
        this.id = nameAliasExpression.alias;
        if (nameAliasExpression.expression != null) {
            this.expressionContainer = new ClientExpressionContainer(nameAliasExpression.expression);
        }
    }

    public ClientQueryField(ClientQueryField source) {
        ValueObjectUtils.checkNotNull(source);
        this.id = source.getId();
        this.type = source.getType();
        this.measure = source.isMeasure();
        this.field = source.getFieldName();
        this.expressionContainer = ValueObjectUtils.copyOf(source.getExpressionContainer());
    }

    @Override
    public String getId() {
        return this.id;
    }

    public ClientQueryField setId(String id) {
        this.id = id;
        return this;
    }

    @XmlElement(name="field")
    public String getFieldName() {
        return this.field;
    }

    public ClientQueryField setFieldName(String fieldName) {
        this.field = fieldName;
        return this;
    }

    @Override
    @XmlTransient
    public String getName() {
        return this.getFieldName();
    }

    @Override
    @XmlTransient
    public String getType() {
        return this.type;
    }

    @XmlTransient
    public boolean isMeasure() {
        return this.measure;
    }

    public ClientQueryField setDataSourceField(ClientDataSourceField field) {
        if (field != null) {
            this.type = field.getType();
            this.measure = field.isMeasure();
            this.setFieldName(field.getName());
        } else {
            this.type = null;
            this.measure = false;
            this.field = null;
        }
        return this;
    }

    @Override
    @XmlTransient
    public String getFieldExpression() {
        if (this.expressionContainer == null) {
            return null;
        }
        return this.expressionContainer.getString();
    }

    @Override
    @XmlElement(name="expression")
    public ClientExpressionContainer getExpressionContainer() {
        return this.expressionContainer;
    }

    @Override
    public ClientQueryField setExpressionContainer(ClientExpressionContainer expressionContainer) {
        this.expressionContainer = expressionContainer;
        return this;
    }

    public void accept(ClientQueryVisitor visitor) {
        visitor.visit(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClientQueryField that = (ClientQueryField)o;
        if (this.isMeasure() != that.isMeasure()) {
            return false;
        }
        if (this.getId() != null ? !this.getId().equals(that.getId()) : that.getId() != null) {
            return false;
        }
        if (this.getType() != null ? !this.getType().equals(that.getType()) : that.getType() != null) {
            return false;
        }
        if (this.expressionContainer != null ? !this.expressionContainer.equals(that.expressionContainer) : that.expressionContainer != null) {
            return false;
        }
        return this.getFieldName() != null ? this.getFieldName().equals(that.getFieldName()) : that.getFieldName() == null;
    }

    public int hashCode() {
        int result = this.getId() != null ? this.getId().hashCode() : 0;
        result = 31 * result + (this.getType() != null ? this.getType().hashCode() : 0);
        result = 31 * result + (this.isMeasure() ? 1 : 0);
        result = 31 * result + (this.getFieldName() != null ? this.getFieldName().hashCode() : 0);
        result = 31 * result + (this.expressionContainer != null ? this.expressionContainer.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "ClientQueryField{id='" + this.id + '\'' + ", type='" + this.type + '\'' + ", measure=" + this.measure + ", field='" + this.field + '\'' + ", expression=" + this.expressionContainer + '}';
    }

    @Override
    public ClientQueryField deepClone() {
        return new ClientQueryField(this);
    }
}

