/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.dto.adhoc.query.field;

import com.jaspersoft.jasperserver.dto.adhoc.datasource.ClientDataSourceField;
import com.jaspersoft.jasperserver.dto.adhoc.query.ClientField;
import com.jaspersoft.jasperserver.dto.adhoc.query.ClientIdentifiable;
import com.jaspersoft.jasperserver.dto.adhoc.query.IExpressionContainer;
import com.jaspersoft.jasperserver.dto.adhoc.query.QueryPatternsUtil;
import com.jaspersoft.jasperserver.dto.adhoc.query.el.ClientExpressionContainer;
import com.jaspersoft.jasperserver.dto.adhoc.query.validation.NotEmpty;
import com.jaspersoft.jasperserver.dto.common.DeepCloneable;
import com.jaspersoft.jasperserver.dto.utils.ValueObjectUtils;
import java.io.Serializable;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;

public class ClientQueryGroup
implements ClientField,
ClientIdentifiable<String>,
IExpressionContainer,
DeepCloneable<ClientQueryGroup>,
Serializable {
    private String id;
    private String type;
    private String categorizer;
    private String fieldName;
    private Boolean includeAll;
    private ClientExpressionContainer expressionContainer;

    public ClientQueryGroup() {
    }

    public ClientQueryGroup(String group) {
        QueryPatternsUtil.NameAliasExpression nameAliasExpression = QueryPatternsUtil.parseNameAliasExpression(group);
        this.fieldName = nameAliasExpression.name;
        this.id = nameAliasExpression.alias;
        if (nameAliasExpression.expression != null) {
            this.expressionContainer = new ClientExpressionContainer(nameAliasExpression.expression);
        }
    }

    public ClientQueryGroup(ClientQueryGroup source) {
        ValueObjectUtils.checkNotNull(source);
        this.id = source.getId();
        this.type = source.getType();
        this.categorizer = source.getCategorizer();
        this.fieldName = source.getFieldName();
        this.includeAll = source.getIncludeAll();
        this.expressionContainer = ValueObjectUtils.copyOf(source.getExpressionContainer());
    }

    @Override
    public ClientQueryGroup deepClone() {
        return new ClientQueryGroup(this);
    }

    public String getCategorizer() {
        return this.categorizer;
    }

    public ClientQueryGroup setCategorizer(String categorizer) {
        this.categorizer = categorizer;
        return this;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public ClientQueryGroup setId(String id) {
        this.id = id;
        return this;
    }

    @NotEmpty
    @XmlElement(name="field")
    public String getFieldName() {
        return this.fieldName;
    }

    public ClientQueryGroup setFieldName(String fieldName) {
        this.fieldName = fieldName;
        return this;
    }

    @Override
    @XmlTransient
    public String getName() {
        return this.getFieldName();
    }

    @Override
    @XmlTransient
    public String getType() {
        return this.type;
    }

    @Override
    @XmlTransient
    public String getFieldExpression() {
        if (this.expressionContainer == null) {
            return null;
        }
        return this.expressionContainer.getString();
    }

    @Override
    @XmlElement(name="expression")
    public ClientExpressionContainer getExpressionContainer() {
        return this.expressionContainer;
    }

    @Override
    public ClientQueryGroup setExpressionContainer(ClientExpressionContainer expressionContainer) {
        this.expressionContainer = expressionContainer;
        return this;
    }

    public Boolean getIncludeAll() {
        return this.includeAll;
    }

    public ClientQueryGroup setIncludeAll(Boolean includeAll) {
        this.includeAll = includeAll;
        return this;
    }

    public ClientQueryGroup setDataSourceField(ClientDataSourceField field) {
        if (field == null) {
            this.fieldName = null;
            this.type = null;
        } else {
            this.fieldName = field.getName();
            this.type = field.getType();
        }
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ClientQueryGroup)) {
            return false;
        }
        ClientQueryGroup that = (ClientQueryGroup)o;
        if (this.getId() != null ? !this.getId().equals(that.getId()) : that.getId() != null) {
            return false;
        }
        if (this.getType() != null ? !this.getType().equals(that.getType()) : that.getType() != null) {
            return false;
        }
        if (this.getCategorizer() != null ? !this.getCategorizer().equals(that.getCategorizer()) : that.getCategorizer() != null) {
            return false;
        }
        if (this.getFieldName() != null ? !this.getFieldName().equals(that.getFieldName()) : that.getFieldName() != null) {
            return false;
        }
        if (this.expressionContainer != null ? !this.expressionContainer.equals(that.expressionContainer) : that.expressionContainer != null) {
            return false;
        }
        return this.getIncludeAll() != null ? this.getIncludeAll().equals(that.getIncludeAll()) : that.getIncludeAll() == null;
    }

    public int hashCode() {
        int result = this.getId() != null ? this.getId().hashCode() : 0;
        result = 31 * result + (this.getType() != null ? this.getType().hashCode() : 0);
        result = 31 * result + (this.getCategorizer() != null ? this.getCategorizer().hashCode() : 0);
        result = 31 * result + (this.getFieldName() != null ? this.getFieldName().hashCode() : 0);
        result = 31 * result + (this.getIncludeAll() != null ? this.getIncludeAll().hashCode() : 0);
        result = 31 * result + (this.expressionContainer != null ? this.expressionContainer.hashCode() : 0);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ClientQueryGroup{");
        sb.append("categorizer='").append(this.categorizer).append('\'');
        sb.append(", id='").append(this.id).append('\'');
        sb.append(", type='").append(this.type).append('\'');
        sb.append(", fieldName='").append(this.fieldName).append('\'');
        sb.append(", expression=").append(this.expressionContainer);
        sb.append(", includeAll=").append(this.includeAll);
        sb.append('}');
        return sb.toString();
    }

    public static class ClientAllGroup
    extends ClientQueryGroup {
        public static final String ALL_GROUP_ID = "__allGroup__";

        public ClientAllGroup() {
            this.setId(ALL_GROUP_ID);
            this.setFieldName(ALL_GROUP_ID);
        }

        public ClientAllGroup(ClientAllGroup other) {
            super(other);
        }

        @Override
        @XmlTransient
        public String getId() {
            return super.getId();
        }

        @Override
        @XmlTransient
        public String getFieldName() {
            return super.getFieldName();
        }

        @Override
        public ClientAllGroup deepClone() {
            return new ClientAllGroup(this);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ClientAllGroup)) {
                return false;
            }
            return super.equals(o);
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder("ClientAllGroup{");
            sb.append("categorizer='").append(this.getCategorizer()).append('\'');
            sb.append(", id='").append(this.getId()).append('\'');
            sb.append(", type='").append(this.getType()).append('\'');
            sb.append(", fieldName='").append(this.getFieldName()).append('\'');
            sb.append(", expression=").append(this.getExpressionContainer());
            sb.append(", includeAll=").append(this.getIncludeAll());
            sb.append('}');
            return sb.toString();
        }
    }
}

