/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.dto.adhoc.query.field;

import com.jaspersoft.jasperserver.dto.adhoc.datasource.ClientDataSourceField;
import com.jaspersoft.jasperserver.dto.adhoc.datasource.ClientDataSourceLevel;
import com.jaspersoft.jasperserver.dto.adhoc.query.field.ClientQueryGroup;
import java.io.Serializable;
import javax.validation.constraints.NotNull;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;

public class ClientQueryLevel
extends ClientQueryGroup
implements Serializable {
    private String dimension;
    private String hierarchyName;

    public ClientQueryLevel() {
    }

    public ClientQueryLevel(ClientQueryLevel source) {
        super(source);
        this.dimension = source.getDimension();
        this.hierarchyName = source.getHierarchyName();
    }

    @Override
    public ClientQueryLevel deepClone() {
        return new ClientQueryLevel(this);
    }

    public String getDimension() {
        return this.dimension;
    }

    @NotNull
    @XmlElement(name="dimension")
    public ClientQueryLevel setDimension(String dimension) {
        this.dimension = dimension;
        return this;
    }

    @XmlElement(name="hierarchy")
    public String getHierarchyName() {
        return this.hierarchyName;
    }

    public ClientQueryLevel setHierarchyName(String hierarchyName) {
        this.hierarchyName = hierarchyName;
        return this;
    }

    @Override
    public ClientQueryLevel setCategorizer(String categorizer) {
        return (ClientQueryLevel)super.setCategorizer(categorizer);
    }

    public ClientQueryLevel setDataSourceField(ClientDataSourceLevel field) {
        super.setDataSourceField(field);
        if (field != null) {
            this.setDimension(field.getDimensionName());
            this.setHierarchyName(field.getHierarchyName());
        } else {
            this.dimension = null;
            this.hierarchyName = null;
        }
        return this;
    }

    @Override
    public ClientQueryLevel setFieldName(String fieldName) {
        return (ClientQueryLevel)super.setFieldName(fieldName);
    }

    @Override
    @XmlTransient
    public ClientQueryLevel setDataSourceField(ClientDataSourceField field) {
        return (ClientQueryLevel)super.setDataSourceField(field);
    }

    @Override
    public ClientQueryLevel setId(String id) {
        return (ClientQueryLevel)super.setId(id);
    }

    @Override
    public ClientQueryLevel setIncludeAll(Boolean includeAll) {
        return (ClientQueryLevel)super.setIncludeAll(includeAll);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ClientQueryLevel)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ClientQueryLevel that = (ClientQueryLevel)o;
        if (this.getDimension() != null ? !this.getDimension().equals(that.getDimension()) : that.getDimension() != null) {
            return false;
        }
        return this.getHierarchyName() != null ? this.getHierarchyName().equals(that.getHierarchyName()) : that.getHierarchyName() == null;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.getDimension() != null ? this.getDimension().hashCode() : 0);
        result = 31 * result + (this.getHierarchyName() != null ? this.getHierarchyName().hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("ClientQueryLevel{");
        sb.append("id='").append(this.getId()).append('\'');
        sb.append(", fieldName='").append(this.getFieldName()).append('\'');
        sb.append(", dimension='").append(this.dimension).append('\'');
        sb.append(", hierarchyName='").append(this.hierarchyName).append('\'');
        sb.append(", categorizer='").append(this.getCategorizer()).append('\'');
        sb.append(", includeAll='").append(this.getIncludeAll()).append('\'');
        sb.append('}');
        return sb.toString();
    }

    public static class ClientAllLevel
    extends ClientQueryLevel {
        public static final String DEFAULT_ALL_LEVEL_FIELD_NAME = "(All)";

        public ClientAllLevel() {
            this.setFieldName(DEFAULT_ALL_LEVEL_FIELD_NAME);
        }

        public ClientAllLevel(ClientQueryLevel level) {
            super(level);
        }

        public ClientAllLevel(String dimensionName) {
            this.setDimension(dimensionName);
        }

        @Override
        @NotNull
        public String getDimension() {
            return super.getDimension();
        }

        @Override
        public ClientAllLevel deepClone() {
            return new ClientAllLevel(this);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ClientAllLevel)) {
                return false;
            }
            return super.equals(o);
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder("ClientAllLevel{");
            sb.append("id='").append(this.getId()).append('\'');
            sb.append(", fieldName='").append(this.getFieldName()).append('\'');
            sb.append(", dimension='").append(this.getDimension()).append('\'');
            sb.append(", hierarchyName='").append(this.getHierarchyName()).append('\'');
            sb.append(", categorizer='").append(this.getCategorizer()).append('\'');
            sb.append(", includeAll=").append(this.getIncludeAll()).append('\'');
            sb.append('}');
            return sb.toString();
        }
    }

    public static class ClientLevelAggregationsRef
    extends ClientQueryLevel {
        public static final String AGGREGATIONS_ID = "__levelAggregations__";
        public static final String AGGREGATIONS_LEVEL_NAME = "Measures";

        public ClientLevelAggregationsRef() {
            this.setId(AGGREGATIONS_ID);
            this.setFieldName(AGGREGATIONS_LEVEL_NAME);
        }

        public ClientLevelAggregationsRef(ClientLevelAggregationsRef other) {
            super(other);
        }

        @Override
        @XmlTransient
        public String getId() {
            return super.getId();
        }

        @Override
        @XmlTransient
        public String getFieldName() {
            return super.getFieldName();
        }

        @Override
        public ClientLevelAggregationsRef deepClone() {
            return new ClientLevelAggregationsRef(this);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ClientLevelAggregationsRef)) {
                return false;
            }
            return super.equals(o);
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder("ClientLevelAggregationsRef{");
            sb.append("id='").append(this.getId()).append('\'');
            sb.append(", fieldName='").append(this.getFieldName()).append('\'');
            sb.append(", dimension='").append(this.getDimension()).append('\'');
            sb.append(", hierarchyName='").append(this.getHierarchyName()).append('\'');
            sb.append(", categorizer='").append(this.getCategorizer()).append('\'');
            sb.append(", includeAll=").append(this.getIncludeAll()).append('\'');
            sb.append('}');
            return sb.toString();
        }
    }
}

