/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.dto.adhoc.query.group;

import com.jaspersoft.jasperserver.dto.adhoc.query.group.ClientGroupBy;
import com.jaspersoft.jasperserver.dto.adhoc.query.group.axis.ClientGroupAxisEnum;
import com.jaspersoft.jasperserver.dto.adhoc.query.group.axis.ClientLevelAxis;
import com.jaspersoft.jasperserver.dto.utils.ValueObjectUtils;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.validation.Valid;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;

@XmlRootElement
public class ClientMultiAxisGroupBy
implements ClientGroupBy<ClientLevelAxis>,
Serializable {
    @Valid
    protected ClientLevelAxis rows;
    @Valid
    protected ClientLevelAxis columns;

    public ClientMultiAxisGroupBy() {
    }

    public ClientMultiAxisGroupBy(ClientMultiAxisGroupBy source) {
        ValueObjectUtils.checkNotNull(source);
        this.rows = ValueObjectUtils.copyOf(source.getRows());
        this.columns = ValueObjectUtils.copyOf(source.getColumns());
    }

    public ClientMultiAxisGroupBy deepClone() {
        return new ClientMultiAxisGroupBy(this);
    }

    @Override
    public ClientLevelAxis getAxis(ClientGroupAxisEnum axis) {
        return this.get(axis.toString());
    }

    @Override
    public ClientLevelAxis getAxis(int index) {
        switch (index) {
            case 0: {
                return this.columns;
            }
            case 1: {
                return this.rows;
            }
        }
        throw new IllegalArgumentException("Not supported axis index: " + index);
    }

    public ClientLevelAxis get(Object key) {
        if (key.equals(ClientGroupAxisEnum.ROWS.toString())) {
            return this.rows;
        }
        if (key.equals(ClientGroupAxisEnum.COLUMNS.toString())) {
            return this.columns;
        }
        return null;
    }

    @Override
    @XmlTransient
    public List<ClientLevelAxis> getAxes() {
        return Arrays.asList(this.rows, this.columns);
    }

    public void addAxis(ClientGroupAxisEnum axis, ClientLevelAxis clientLevelAxis) {
        if (axis.equals((Object)ClientGroupAxisEnum.ROWS)) {
            this.rows = clientLevelAxis;
        } else if (axis.equals((Object)ClientGroupAxisEnum.COLUMNS)) {
            this.columns = clientLevelAxis;
        } else {
            throw new IllegalArgumentException(String.format("unsupported axis %s for MultiAxisGroupBy", axis.toString()));
        }
    }

    @XmlElement(name="rows")
    public ClientLevelAxis getRows() {
        return this.rows;
    }

    public ClientMultiAxisGroupBy setRows(ClientLevelAxis rows) {
        this.rows = rows;
        return this;
    }

    @XmlElement(name="columns")
    public ClientLevelAxis getColumns() {
        return this.columns;
    }

    public ClientMultiAxisGroupBy setColumns(ClientLevelAxis columns) {
        this.columns = columns;
        return this;
    }

    public Set<String> keySet() {
        HashSet<String> keys = new HashSet<String>();
        if (this.rows != null) {
            keys.add(ClientGroupAxisEnum.ROWS.toString());
        }
        if (this.columns != null) {
            keys.add(ClientGroupAxisEnum.COLUMNS.toString());
        }
        return keys;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClientMultiAxisGroupBy that = (ClientMultiAxisGroupBy)o;
        if (this.rows != null ? !this.rows.equals(that.rows) : that.rows != null) {
            return false;
        }
        return this.columns != null ? this.columns.equals(that.columns) : that.columns == null;
    }

    public int hashCode() {
        int result = this.rows != null ? this.rows.hashCode() : 0;
        result = 31 * result + (this.columns != null ? this.columns.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "ClientMultiAxisGroupBy{rows=" + this.rows + ", columns=" + this.columns + '}';
    }
}

