/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.dto.adhoc.query.group;

import com.jaspersoft.jasperserver.dto.adhoc.query.field.ClientQueryGroup;
import com.jaspersoft.jasperserver.dto.adhoc.query.group.ClientGroupBy;
import com.jaspersoft.jasperserver.dto.adhoc.query.group.axis.ClientGroupAxis;
import com.jaspersoft.jasperserver.dto.adhoc.query.group.axis.ClientGroupAxisEnum;
import com.jaspersoft.jasperserver.dto.adhoc.query.validation.CheckAllGroupPosition;
import com.jaspersoft.jasperserver.dto.utils.ValueObjectUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.validation.Valid;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;

@XmlRootElement
public class ClientQueryGroupBy
implements ClientGroupBy<ClientGroupAxis>,
Serializable {
    @Valid
    @CheckAllGroupPosition
    private List<ClientQueryGroup> groups;

    public ClientQueryGroupBy() {
        this.groups = new ArrayList<ClientQueryGroup>();
    }

    public ClientQueryGroupBy(ClientQueryGroupBy source) {
        ValueObjectUtils.checkNotNull(source);
        this.groups = ValueObjectUtils.copyOf(source.getGroups());
    }

    public ClientQueryGroupBy deepClone() {
        return new ClientQueryGroupBy(this);
    }

    @XmlTransient
    public ClientGroupAxis getGroupAxis() {
        return new ClientGroupAxis((Collection<? extends ClientQueryGroup>)this.groups);
    }

    @Override
    public ClientGroupAxis getAxis(ClientGroupAxisEnum name) {
        if (!ClientGroupAxisEnum.GROUPS.equals((Object)name)) {
            throw new IllegalArgumentException(String.format("unsupported axis %s for FlatGroupBy", name.toString()));
        }
        return this.getGroupAxis();
    }

    @Override
    public ClientGroupAxis getAxis(int index) {
        if (index != 0) {
            throw new IllegalArgumentException(String.format("unsupported axis index: %d", index));
        }
        return this.getGroupAxis();
    }

    @Override
    @XmlTransient
    public List<ClientGroupAxis> getAxes() {
        return Collections.singletonList(this.getGroupAxis());
    }

    public ClientQueryGroupBy setGroups(List<? extends ClientQueryGroup> groups) {
        this.groups = groups != null ? groups : new ArrayList();
        return this;
    }

    public ClientQueryGroupBy setGroupsStr(List<String> groups) {
        this.groups = groups == null ? new ArrayList<ClientQueryGroup>() : groups.stream().map(s -> {
            ClientQueryGroup g = new ClientQueryGroup((String)s);
            if ("__allGroup__".equals(g.getFieldName())) {
                g = new ClientQueryGroup.ClientAllGroup();
            }
            return g;
        }).collect(Collectors.toList());
        return this;
    }

    public List<? extends ClientQueryGroup> getGroups() {
        return this.groups;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClientQueryGroupBy that = (ClientQueryGroupBy)o;
        return this.groups.equals(that.groups);
    }

    public int hashCode() {
        return this.groups.hashCode();
    }

    public String toString() {
        return "ClientQueryGroupBy{groups=" + this.groups + '}';
    }
}

