/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.dto.adhoc.query.group.axis;

import com.jaspersoft.jasperserver.dto.adhoc.query.field.ClientQueryGroup;
import com.jaspersoft.jasperserver.dto.adhoc.query.group.axis.ClientAxis;
import com.jaspersoft.jasperserver.dto.common.DeepCloneable;
import com.jaspersoft.jasperserver.dto.utils.ValueObjectUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ClientBaseAxis<T extends ClientQueryGroup>
implements ClientAxis<T>,
DeepCloneable<ClientBaseAxis<T>>,
Serializable {
    private List<T> items;

    protected ClientBaseAxis() {
        this.items = new ArrayList<T>();
    }

    protected ClientBaseAxis(ClientBaseAxis<T> other) {
        ValueObjectUtils.checkNotNull(other);
        this.items = ValueObjectUtils.copyOf(other.getItems());
    }

    public ClientBaseAxis(Collection<? extends T> c) {
        this.items = new ArrayList<T>(c);
    }

    @Override
    public T get(String id) {
        if (id == null) {
            return null;
        }
        for (ClientQueryGroup item : this.items) {
            if (!id.equals(item.getId())) continue;
            return (T)item;
        }
        return null;
    }

    @Override
    public T get(int index) {
        return (T)((ClientQueryGroup)this.items.get(index));
    }

    @Override
    public List<T> getItems() {
        return this.items;
    }

    protected ClientBaseAxis<T> setItems(List<T> items) {
        this.items = items;
        return this;
    }

    @Override
    public int size() {
        return this.items.size();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClientBaseAxis that = (ClientBaseAxis)o;
        return this.getItems() != null ? this.getItems().equals(that.getItems()) : that.getItems() == null;
    }

    public int hashCode() {
        return this.getItems() != null ? this.getItems().hashCode() : 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ClientBaseAxis{");
        sb.append("items=").append(this.items);
        sb.append('}');
        return sb.toString();
    }

    @Override
    public ClientBaseAxis<T> deepClone() {
        return new ClientBaseAxis<T>(this);
    }
}

