/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.dto.adhoc.query.group.axis;

import com.jaspersoft.jasperserver.dto.adhoc.query.expansion.ClientExpandable;
import com.jaspersoft.jasperserver.dto.adhoc.query.expansion.ClientLevelExpansion;
import com.jaspersoft.jasperserver.dto.adhoc.query.expansion.ClientMemberExpansion;
import com.jaspersoft.jasperserver.dto.adhoc.query.field.ClientQueryLevel;
import com.jaspersoft.jasperserver.dto.adhoc.query.group.axis.ClientBaseAxis;
import com.jaspersoft.jasperserver.dto.utils.ValueObjectUtils;
import java.util.Collection;
import java.util.List;
import javax.validation.Valid;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="axis")
public class ClientLevelAxis
extends ClientBaseAxis<ClientQueryLevel> {
    @Valid
    private List<ClientExpandable> expansions;

    public ClientLevelAxis() {
    }

    public ClientLevelAxis(ClientLevelAxis axis) {
        super(axis);
        this.expansions = ValueObjectUtils.copyOf(axis.getExpansions());
    }

    public ClientLevelAxis(Collection<? extends ClientQueryLevel> c) {
        super(c);
    }

    public ClientLevelAxis(Collection<? extends ClientQueryLevel> c, List<ClientExpandable> expansions) {
        super(c);
        this.setExpansions(expansions);
    }

    @XmlElementWrapper
    @XmlElements(value={@XmlElement(name="member", type=ClientMemberExpansion.class), @XmlElement(name="level", type=ClientLevelExpansion.class)})
    public List<ClientExpandable> getExpansions() {
        return this.expansions;
    }

    public ClientLevelAxis setExpansions(List<ClientExpandable> expansions) {
        this.expansions = expansions;
        return this;
    }

    @Override
    @Valid
    @XmlElementWrapper
    @XmlElements(value={@XmlElement(name="level", type=ClientQueryLevel.class), @XmlElement(name="allLevel", type=ClientQueryLevel.ClientAllLevel.class), @XmlElement(name="aggregations", type=ClientQueryLevel.ClientLevelAggregationsRef.class)})
    public List<ClientQueryLevel> getItems() {
        return super.getItems();
    }

    public ClientLevelAxis setItems(List<ClientQueryLevel> items) {
        return (ClientLevelAxis)super.setItems(items);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("ClientLevelAxis{");
        sb.append("items=").append(this.getItems());
        sb.append("expansions=").append(this.expansions);
        sb.append('}');
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ClientLevelAxis that = (ClientLevelAxis)o;
        return this.expansions != null ? this.expansions.equals(that.expansions) : that.expansions == null;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.expansions != null ? this.expansions.hashCode() : 0);
        return result;
    }

    @Override
    public ClientLevelAxis deepClone() {
        return new ClientLevelAxis(this);
    }
}

