/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.dto.adhoc.query.order;

import com.jaspersoft.jasperserver.dto.adhoc.query.ClientField;
import com.jaspersoft.jasperserver.dto.adhoc.query.ClientFieldReference;
import com.jaspersoft.jasperserver.dto.adhoc.query.IExpressionContainer;
import com.jaspersoft.jasperserver.dto.adhoc.query.QueryPatternsUtil;
import com.jaspersoft.jasperserver.dto.adhoc.query.el.ClientExpressionContainer;
import com.jaspersoft.jasperserver.dto.adhoc.query.order.ClientOrder;
import com.jaspersoft.jasperserver.dto.adhoc.query.validation.CheckGenericOrderFieldReference;
import com.jaspersoft.jasperserver.dto.utils.ValueObjectUtils;
import java.io.Serializable;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;

@CheckGenericOrderFieldReference
public class ClientGenericOrder
implements ClientOrder,
ClientFieldReference,
ClientField,
IExpressionContainer,
Serializable {
    public static final Boolean IS_AGGREGATION_DEFAULT = false;
    private Boolean isAscending = true;
    private Boolean isAggregationLevel = IS_AGGREGATION_DEFAULT;
    private String type;
    private String fieldRef;
    private ClientExpressionContainer expressionContainer;

    public ClientGenericOrder() {
    }

    public ClientGenericOrder(String orderExpression) {
        QueryPatternsUtil.NameExpressionOrder nameExpressionOrder = QueryPatternsUtil.parseNameExpressionOrder(orderExpression);
        this.fieldRef = nameExpressionOrder.name;
        if (nameExpressionOrder.expression != null) {
            this.expressionContainer = new ClientExpressionContainer(nameExpressionOrder.expression);
        }
        if ("DESC".equals(nameExpressionOrder.order)) {
            this.isAscending = false;
        }
    }

    public ClientGenericOrder(ClientGenericOrder sorting) {
        ValueObjectUtils.checkNotNull(sorting);
        this.setAscending(sorting.isAscending()).setFieldReference(sorting.getFieldReference()).setAggregation(sorting.isAggregationLevel());
        this.expressionContainer = ValueObjectUtils.copyOf(sorting.getExpressionContainer());
    }

    @Override
    public ClientGenericOrder deepClone() {
        return new ClientGenericOrder(this);
    }

    @Override
    public Boolean isAscending() {
        return this.isAscending;
    }

    public ClientGenericOrder setAscending(Boolean isAscending) {
        this.isAscending = isAscending;
        return this;
    }

    @Override
    @XmlElement(name="fieldRef")
    public String getFieldReference() {
        return this.fieldRef;
    }

    public ClientGenericOrder setFieldReference(String fieldReference) {
        this.fieldRef = fieldReference;
        return this;
    }

    @XmlTransient
    public Boolean isAggregationLevel() {
        return this.isAggregationLevel;
    }

    @XmlElement(name="aggregation")
    public Boolean isAggregation() {
        return this.isAggregationLevel == IS_AGGREGATION_DEFAULT ? null : this.isAggregationLevel;
    }

    public ClientGenericOrder setAggregation(Boolean aggregationLevel) {
        this.isAggregationLevel = aggregationLevel;
        return this;
    }

    @Override
    @XmlTransient
    public String getFieldExpression() {
        if (this.expressionContainer == null) {
            return null;
        }
        return this.expressionContainer.getString();
    }

    @Override
    @XmlTransient
    public String getType() {
        return this.type;
    }

    @Override
    @XmlTransient
    public String getName() {
        return this.fieldRef;
    }

    @Override
    @XmlElement(name="expression")
    public ClientExpressionContainer getExpressionContainer() {
        return this.expressionContainer;
    }

    @Override
    public ClientGenericOrder setExpressionContainer(ClientExpressionContainer expressionContainer) {
        this.expressionContainer = expressionContainer;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ClientGenericOrder)) {
            return false;
        }
        ClientGenericOrder that = (ClientGenericOrder)o;
        if (this.isAscending != null ? !this.isAscending.equals(that.isAscending) : that.isAscending != null) {
            return false;
        }
        if (this.isAggregationLevel != null ? !this.isAggregationLevel.equals(that.isAggregationLevel) : that.isAggregationLevel != null) {
            return false;
        }
        if (this.expressionContainer != null ? !this.expressionContainer.equals(that.expressionContainer) : that.expressionContainer != null) {
            return false;
        }
        return this.fieldRef != null ? this.fieldRef.equals(that.fieldRef) : that.fieldRef == null;
    }

    public int hashCode() {
        int result = this.isAscending != null ? this.isAscending.hashCode() : 0;
        result = 31 * result + (this.isAggregationLevel != null ? this.isAggregationLevel.hashCode() : 0);
        result = 31 * result + (this.fieldRef != null ? this.fieldRef.hashCode() : 0);
        result = 31 * result + (this.expressionContainer != null ? this.expressionContainer.hashCode() : 0);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ClientGenericOrder{");
        sb.append("isAscending=").append(this.isAscending);
        sb.append(", isAggregationLevel=").append(this.isAggregationLevel);
        sb.append(", fieldReference='").append(this.fieldRef).append('\'');
        sb.append(", expression=").append(this.expressionContainer);
        sb.append('}');
        return sb.toString();
    }
}

