/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.dto.adhoc.query.order;

import com.jaspersoft.jasperserver.dto.adhoc.query.order.ClientOrder;
import com.jaspersoft.jasperserver.dto.utils.ValueObjectUtils;
import java.io.Serializable;
import java.util.List;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;

public class ClientPathOrder
implements ClientOrder,
Serializable {
    @NotNull
    private Boolean isAscending;
    @NotNull
    @Size(min=1)
    private List<String> path;

    public ClientPathOrder() {
    }

    public ClientPathOrder(ClientPathOrder source) {
        ValueObjectUtils.checkNotNull(source);
        this.isAscending = source.isAscending();
        this.path = ValueObjectUtils.copyOf(source.getPath());
    }

    @Override
    public ClientPathOrder deepClone() {
        return new ClientPathOrder(this);
    }

    @XmlElementWrapper(name="path")
    @XmlElement(name="item")
    public List<String> getPath() {
        return this.path;
    }

    public ClientPathOrder setPath(List<String> path) {
        this.path = path;
        return this;
    }

    @Override
    public Boolean isAscending() {
        return this.isAscending;
    }

    public ClientPathOrder setAscending(Boolean ascending) {
        this.isAscending = ascending;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClientPathOrder that = (ClientPathOrder)o;
        if (this.isAscending != null ? !this.isAscending.equals(that.isAscending) : that.isAscending != null) {
            return false;
        }
        return this.path != null ? this.path.equals(that.path) : that.path == null;
    }

    public int hashCode() {
        int result = 31 * (this.isAscending != null ? this.isAscending.hashCode() : 0);
        result = 31 * result + (this.path != null ? this.path.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "ClientPathOrder{isAscending=" + this.isAscending() + ", path=" + this.path + "}";
    }
}

