/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.dto.adhoc.query.select;

import com.jaspersoft.jasperserver.dto.adhoc.query.ast.ClientQueryClause;
import com.jaspersoft.jasperserver.dto.adhoc.query.ast.ClientQueryVisitor;
import com.jaspersoft.jasperserver.dto.adhoc.query.field.ClientQueryAggregatedField;
import com.jaspersoft.jasperserver.dto.adhoc.query.field.ClientQueryField;
import com.jaspersoft.jasperserver.dto.adhoc.query.validation.CheckClientSelect;
import com.jaspersoft.jasperserver.dto.adhoc.query.validation.CheckQueryDetailsNull;
import com.jaspersoft.jasperserver.dto.adhoc.query.validation.groups.MultiAxisQueryValidationGroup;
import com.jaspersoft.jasperserver.dto.common.DeepCloneable;
import com.jaspersoft.jasperserver.dto.utils.ValueObjectUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.validation.Valid;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;

@CheckClientSelect
public class ClientSelect
implements ClientQueryClause,
DeepCloneable<ClientSelect>,
Serializable {
    @Valid
    @CheckQueryDetailsNull(groups={MultiAxisQueryValidationGroup.class})
    private List<ClientQueryField> fields;
    @Valid
    private List<ClientQueryField> distinctFields;
    @Valid
    private List<ClientQueryAggregatedField> aggregations;

    public ClientSelect() {
    }

    public ClientSelect(ClientSelect source) {
        ValueObjectUtils.checkNotNull(source);
        this.fields = ValueObjectUtils.copyOf(source.getFields());
        this.distinctFields = ValueObjectUtils.copyOf(source.getDistinctFields());
        this.aggregations = ValueObjectUtils.copyOf(source.getAggregations());
    }

    public ClientSelect(List<ClientQueryField> fields) {
        this.setFields(new ArrayList<ClientQueryField>(fields));
    }

    @Override
    public ClientSelect deepClone() {
        return new ClientSelect(this);
    }

    public ClientQueryField getField(int index) {
        return this.fields.get(index);
    }

    public ClientQueryField getField(String id) {
        if (id == null) {
            throw new IllegalArgumentException("Cannot search query field by null id");
        }
        for (ClientQueryField field : this.fields) {
            if (!id.equals(field.getId()) && !field.getFieldName().equals(id)) continue;
            return field;
        }
        return null;
    }

    @XmlElementWrapper(name="fields")
    @XmlElement(name="field")
    public List<ClientQueryField> getFields() {
        return this.fields;
    }

    public ClientSelect setFields(List<ClientQueryField> fields) {
        this.fields = fields != null ? fields : new ArrayList();
        return this;
    }

    public ClientSelect setFieldsStr(List<String> fields) {
        this.fields = fields == null ? new ArrayList<ClientQueryField>() : fields.stream().map(s -> new ClientQueryField((String)s)).collect(Collectors.toList());
        return this;
    }

    @XmlElementWrapper(name="distinctFields")
    @XmlElement(name="distinctField")
    public List<ClientQueryField> getDistinctFields() {
        return this.distinctFields;
    }

    public ClientSelect setDistinctFields(List<ClientQueryField> distinctFields) {
        this.distinctFields = distinctFields;
        return this;
    }

    @XmlElementWrapper(name="aggregations")
    @XmlElement(name="aggregation")
    public List<ClientQueryAggregatedField> getAggregations() {
        return this.aggregations;
    }

    public ClientSelect setAggregations(List<ClientQueryAggregatedField> aggregations) {
        this.aggregations = aggregations != null ? aggregations : new ArrayList();
        return this;
    }

    public ClientSelect setAggregationsStr(List<String> aggregations) {
        this.aggregations = aggregations == null ? new ArrayList<ClientQueryAggregatedField>() : aggregations.stream().map(s -> new ClientQueryAggregatedField((String)s)).collect(Collectors.toList());
        return this;
    }

    public void accept(ClientQueryVisitor visitor) {
        if (this.fields != null) {
            for (ClientQueryField field : this.fields) {
                field.accept(visitor);
            }
        }
        if (this.getDistinctFields() != null) {
            for (ClientQueryField field : this.getDistinctFields()) {
                field.accept(visitor);
            }
        }
        if (this.aggregations != null) {
            for (ClientQueryAggregatedField aggregatedField : this.aggregations) {
                aggregatedField.accept(visitor);
            }
        }
        visitor.visit(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClientSelect that = (ClientSelect)o;
        if (this.getFields() != null ? !this.getFields().equals(that.getFields()) : that.getFields() != null) {
            return false;
        }
        if (this.getDistinctFields() != null ? !this.getDistinctFields().equals(that.getDistinctFields()) : that.getDistinctFields() != null) {
            return false;
        }
        return this.getAggregations() != null ? this.getAggregations().equals(that.getAggregations()) : that.getAggregations() == null;
    }

    public int hashCode() {
        int result = this.getFields() != null ? this.getFields().hashCode() : 0;
        result = 31 * result + (this.getDistinctFields() != null ? this.getDistinctFields().hashCode() : 0);
        result = 31 * result + (this.getAggregations() != null ? this.getAggregations().hashCode() : 0);
        return result;
    }

    public String toString() {
        return "ClientSelect{fields=" + this.fields + ", distinctFields=" + this.distinctFields + ", aggregations=" + this.aggregations + '}';
    }
}

