/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.dto.adhoc.query.validation;

import com.jaspersoft.jasperserver.dto.adhoc.query.field.ClientQueryGroup;
import com.jaspersoft.jasperserver.dto.adhoc.query.validation.CheckAllGroupPosition;
import com.jaspersoft.jasperserver.dto.common.ErrorDescriptor;
import com.jaspersoft.jasperserver.dto.common.ValidationErrorDescriptorBuilder;
import com.jaspersoft.jasperserver.dto.executions.QueryExecutionsErrorCode;
import java.util.List;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import javax.validation.ConstraintViolation;

public class CheckAllGroupPositionValidator
implements ConstraintValidator<CheckAllGroupPosition, List<ClientQueryGroup>>,
ValidationErrorDescriptorBuilder {
    public void initialize(CheckAllGroupPosition constraintAnnotation) {
    }

    public boolean isValid(List<ClientQueryGroup> groups, ConstraintValidatorContext context) {
        if (groups.size() > 1) {
            if (this.isAllGroup(groups.get(0))) {
                return true;
            }
            for (ClientQueryGroup g : groups) {
                if (!this.isAllGroup(g)) continue;
                return false;
            }
        }
        return true;
    }

    public ErrorDescriptor build(ConstraintViolation violation) {
        return QueryExecutionsErrorCode.QUERY_GROUPBY_ALLGROUP_NOT_FIRST.createDescriptor(violation.getPropertyPath().toString());
    }

    private boolean isAllGroup(ClientQueryGroup group) {
        return group instanceof ClientQueryGroup.ClientAllGroup;
    }
}

