/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.dto.adhoc.query.validation;

import com.jaspersoft.jasperserver.dto.adhoc.query.el.ClientExpression;
import com.jaspersoft.jasperserver.dto.adhoc.query.validation.CheckExpressionOperandsSize;
import com.jaspersoft.jasperserver.dto.common.ErrorDescriptor;
import com.jaspersoft.jasperserver.dto.common.ValidationErrorDescriptorBuilder;
import com.jaspersoft.jasperserver.dto.executions.QueryExecutionsErrorCode;
import java.util.List;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import javax.validation.ConstraintViolation;

public class CheckExpressionOperandsSizeValidator
implements ConstraintValidator<CheckExpressionOperandsSize, List<ClientExpression>>,
ValidationErrorDescriptorBuilder {
    private Integer annotationMin;
    private Integer annotationMax;

    public void initialize(CheckExpressionOperandsSize constraintAnnotation) {
        this.annotationMin = constraintAnnotation.min();
        this.annotationMax = constraintAnnotation.max();
    }

    public boolean isValid(List<ClientExpression> value, ConstraintValidatorContext context) {
        return value == null || value.size() >= this.annotationMin && value.size() <= this.annotationMax;
    }

    public ErrorDescriptor build(ConstraintViolation violation) {
        return QueryExecutionsErrorCode.QUERY_EXPRESSION_OPERANDS_SIZE_OF_BOUND.createDescriptor(violation.getPropertyPath().toString(), this.annotationMin.toString(), this.annotationMax.toString());
    }
}

