/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.dto.adhoc.query.validation;

import com.jaspersoft.jasperserver.dto.adhoc.query.el.ClientExpression;
import com.jaspersoft.jasperserver.dto.adhoc.query.el.ClientExpressionContainer;
import com.jaspersoft.jasperserver.dto.adhoc.query.validation.CheckExpressionType;
import com.jaspersoft.jasperserver.dto.common.ErrorDescriptor;
import com.jaspersoft.jasperserver.dto.common.ValidationErrorDescriptorBuilder;
import com.jaspersoft.jasperserver.dto.executions.QueryExecutionsErrorCode;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import javax.validation.ConstraintViolation;

public class CheckExpressionTypeValidator
implements ConstraintValidator<CheckExpressionType, ClientExpressionContainer>,
ValidationErrorDescriptorBuilder {
    private Set<Class> acceptedExpressions;

    public void initialize(CheckExpressionType constraintAnnotation) {
        this.acceptedExpressions = new HashSet<Class<? extends ClientExpression>>(Arrays.asList(constraintAnnotation.value()));
    }

    public boolean isValid(ClientExpressionContainer value, ConstraintValidatorContext context) {
        if (value == null || value.getObject() == null) {
            return true;
        }
        return this.acceptedExpressions.contains(value.getObject().getClass());
    }

    public ErrorDescriptor build(ConstraintViolation violation) {
        String type = ((ClientExpressionContainer)violation.getInvalidValue()).getObject().getClass().getSimpleName();
        return QueryExecutionsErrorCode.createDescriptorFrom(violation.getMessageTemplate(), type);
    }
}

